/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;

@CheckVersion(value="16.1.31")
@CheckID(value="XVM15c")
@CheckName(value="XVM15c")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.DRIVER, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Mandatory accept_tr(), start_tr() and end_tr() calls in Driver Run Phase")
@CheckDescription(value="Inside the run phase method of a driver accept_tr(), start_tr and end_tr() should be called.\n\nException: Virtual drivers are not checked.")
public class CheckOVM15c
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of class full names. Classes extending the base classes will be skipped", name="skipClassesExtendingBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipClassesExtendingBaseClasses;
    private static final Set<String> TRANSACTION_FUNCTION_NAMES = new HashSet<String>();
    private String fComponentClassFullName;
    private Set<RfClass> skippedBaseClasses;

    static {
        TRANSACTION_FUNCTION_NAMES.add("accept_tr");
        TRANSACTION_FUNCTION_NAMES.add("begin_tr");
        TRANSACTION_FUNCTION_NAMES.add("end_tr");
    }

    public CheckOVM15c(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fComponentClassFullName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component");
        if (this.fOVMProject.fDrivers.isEmpty()) {
            return;
        }
        this.skippedBaseClasses = new HashSet<RfClass>();
        for (String baseClassName : this.pSkipClassesExtendingBaseClasses) {
            RfClass baseClass = this.fOVMProject.getRfProject().getClass(baseClassName, true);
            if (baseClass == null) continue;
            this.skippedBaseClasses.add(baseClass);
        }
        for (RfClass driver : this.fOVMProject.fDrivers.values()) {
            this.notifyCheckAlive();
            if (driver.hasVirtualQualifier() || LintUtils.isSubClassOfAny(driver, this.skippedBaseClasses)) continue;
            RfFunction runFct = driver.getLocalMember(RfFunction.class, this.fOVMProject.getRunPhaseMethodName(), true);
            if (runFct == null) {
                this.addHit(driver, "Driver '" + LintUtils.getNamedElementFullName(driver) + "' does not have " + this.fOVMProject.getRunPhaseMethodName() + "()");
                continue;
            }
            HashSet<String> foundCalls = new HashSet<String>();
            HashSet<RfFunction> visited = new HashSet<RfFunction>();
            this.checkFunctionCallTree(driver, runFct, visited, foundCalls);
            if (foundCalls.size() >= 3) continue;
            HashSet<String> missingFunctionNames = new HashSet<String>();
            missingFunctionNames.addAll(TRANSACTION_FUNCTION_NAMES);
            missingFunctionNames.removeAll(foundCalls);
            this.addHit(driver, "Driver '" + LintUtils.getNamedElementFullName(driver) + "' does not call " + String.join((CharSequence)", ", missingFunctionNames) + " in it's " + this.fOVMProject.getRunPhaseMethodName() + "()");
        }
    }

    private void checkFunctionCallTree(RfClass driver, RfFunction function, Set<RfFunction> visited, Set<String> foundCalls) {
        if (visited.contains(function)) {
            return;
        }
        visited.add(function);
        if (foundCalls.size() == 3) {
            return;
        }
        List<RfFunctionCall> functionCalls = function.getFunctionCallsWithPrefix("", 2);
        for (RfFunctionCall functionCall : functionCalls) {
            if (foundCalls.size() == 3) {
                return;
            }
            if (TRANSACTION_FUNCTION_NAMES.contains(functionCall.getFunctionName())) {
                if (!this.checkFunctionCall(driver, functionCall)) continue;
                foundCalls.add(functionCall.getName());
                continue;
            }
            if (functionCall.getFunction() == null) continue;
            this.checkFunctionCallTree(driver, functionCall.getFunction(), visited, foundCalls);
        }
    }

    private boolean checkFunctionCall(RfClass driver, RfFunctionCall functionCall) {
        if (functionCall.getFunction() == null) {
            return false;
        }
        RfFunction function = functionCall.getFunction();
        RfClass clazz = function.getEnclosingScope(RfClass.class);
        if (clazz == null) {
            return false;
        }
        return clazz.getFullName().equals(this.fComponentClassFullName);
    }
}

