/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.XVMLintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;

@CheckVersion(value="3.1")
@CheckID(value="XVM16")
@CheckName(value="XVM16")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.VIRTUAL_INTERFACE, RuleLabel.DRIVER, RuleLabel.MONITOR, RuleLabel.CLASS, RuleLabel.VERIFICATION})
@CheckTitle(value="Mandatory Virtual Interface in Drivers and Monitors")
@CheckDescription(value="Driver and monitor classes must contain a virtual interface declaration. Virtual drivers or monitors are not checked.")
public class CheckOVM16
extends OVMComplianceCheck {
    public CheckOVM16(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fDrivers.isEmpty() && this.fOVMProject.fMonitors.isEmpty()) {
            return;
        }
        for (RfClass monitor : this.fOVMProject.fMonitors.values()) {
            this.checkVirtualInterface(monitor);
        }
        for (RfClass driver : this.fOVMProject.fDrivers.values()) {
            this.checkVirtualInterface(driver);
        }
    }

    private void checkVirtualInterface(RfClass classs) {
        if (classs == null) {
            return;
        }
        if (classs.hasVirtualQualifier()) {
            return;
        }
        this.notifyCheckAlive();
        List<RfField> fields = XVMLintUtils.getVirtualInterfaceFieldsInClass(classs, 2);
        if (fields == null || fields.isEmpty()) {
            this.addHit(classs, "Virtual interface not found in '" + classs.getFullName() + "'!");
        }
    }
}

