/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="3.1")
@CheckID(value="XVM20")
@CheckName(value="XVM20")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.MONITOR, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Mandatory Monitor Run Phase")
@CheckDescription(value="Inside a monitor class the run phase method must exist.\n\nCheck supports pre-waiving.")
public class CheckOVM20
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, if the monitor class doesn't directly inherit from xvm_monitor and the parent implements run_phase(), the rule shall pass.", name="passIfParentHasRunPhase", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pPassIfParentHasRunPhaseValue;

    public CheckOVM20(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fMonitors.isEmpty()) {
            return;
        }
        for (RfClass monitor : this.fOVMProject.fMonitors.values()) {
            if (monitor.hasVirtualQualifier()) continue;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(monitor.getFile())) continue;
            int scope = !this.pPassIfParentHasRunPhaseValue ? 1 : 2;
            List<RfFunction> candidates = monitor.getTasksWithPrefix(this.fOVMProject.getRunPhaseMethodName(), 1, scope, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (candidates != null && !candidates.isEmpty() && !this.fOVMProject.isOVMElement(candidates.get(0).getEnclosingScope())) continue;
            StringBuilder message = new StringBuilder().append("'").append(this.fOVMProject.getRunPhaseMethodName()).append("()'").append(" method not found in monitor '").append(LintUtils.getNamedElementFullName(monitor)).append("'");
            if (this.pPassIfParentHasRunPhaseValue) {
                message.append(" or in its parent!");
            }
            this.addHit(monitor, message.toString());
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

