/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Iterator;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="3.1")
@CheckID(value="XVM22a")
@CheckName(value="XVM22a")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.MONITOR, RuleLabel.COVERGROUP, RuleLabel.CLASS, RuleLabel.COVERPOINT, RuleLabel.VERIFICATION})
@CheckTitle(value="Monitor Has Covergroups")
@CheckDescription(value="The monitor class should at least include one covergroup and one coverpoint statement.\n\nCheck supports pre-waiving.")
public class CheckOVM22a
extends OVMComplianceCheck {
    public CheckOVM22a(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fMonitors.isEmpty()) {
            return;
        }
        for (RfClass monitor : this.fOVMProject.fMonitors.values()) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(monitor.getFile())) continue;
            boolean found = false;
            List<RfCovergroup> covergroups = monitor.getCovergroupsWithPrefix("", 2, 2);
            if (covergroups != null) {
                for (RfCovergroup covergroup : covergroups) {
                    List<RfCoverpoint> candidates = covergroup.getLocalMembers(RfCoverpoint.class);
                    if (candidates == null || candidates.isEmpty()) continue;
                    Iterator it = candidates.iterator();
                    RfCoverpoint cvp = (RfCoverpoint)it.next();
                    this.addPassedHit(covergroup, "Covergroup '" + covergroup.getName() + "' found in monitor '" + monitor.getName() + "'");
                    this.addPassedHit(cvp, "Coverpoint '" + cvp.getName() + "' found in monitor '" + monitor.getName() + "'");
                    found = true;
                }
            }
            if (found) continue;
            this.addHit(monitor, "No covergroup with at least one coverpoint found in '" + monitor.getName() + "'");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

