/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;

@CheckVersion(value="3.1")
@CheckID(value="XVM22b")
@CheckName(value="XVM22b")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.MONITOR, RuleLabel.COVERGROUP, RuleLabel.CLASS_INSTANTIATION, RuleLabel.CONSTRUCTOR, RuleLabel.VERIFICATION})
@CheckTitle(value="Monitor's Covergroups Instantiation")
@CheckDescription(value="The monitor covergroups must be constructed in the new() method.\n\nCheck supports pre-waiving.")
public class CheckOVM22b
extends OVMComplianceCheck {
    public CheckOVM22b(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fMonitors.isEmpty()) {
            return;
        }
        for (RfClass monitor : this.fOVMProject.fMonitors.values()) {
            List<RfCovergroup> covergroups;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(monitor.getFile())) continue;
            List<RfFunction> constructors = monitor.getConstructorsWithPrefix("new", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            RfFunction constructor = null;
            if (constructors != null && !constructors.isEmpty()) {
                constructor = constructors.get(0);
            }
            if ((covergroups = monitor.getCovergroupsWithPrefix("", 2, 1)) == null) continue;
            for (RfCovergroup covergroup : covergroups) {
                List<RfFunctionCall> functionCalls;
                boolean found = false;
                if (constructor != null && (functionCalls = constructor.getFunctionCallsWithPrefix("new", 1)) != null) {
                    for (RfFunctionCall functionCall : functionCalls) {
                        String covergroupName = covergroup.getName();
                        if (!covergroupName.equals(functionCall.getLValue())) continue;
                        this.addPassedHit(functionCall, "Covergroup " + covergroup.getName() + " is constructed in the new() method");
                        found = true;
                    }
                }
                if (found) continue;
                this.addHit(covergroup, "Covergroup " + covergroup.getName() + " is not constructed in the new() method");
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

