/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="3.1")
@CheckID(value="XVM23a")
@CheckName(value="XVM23a")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.MONITOR, RuleLabel.ANALYSIS_PORT, RuleLabel.VERIFICATION})
@CheckTitle(value="Monitor Has Analysis Ports")
@CheckDescription(value="To properly connect to a scoreboard, xvm_analysis_ports should be implemented inside a monitor class.\n\nException: Virtual monitors are not checked.\n\nCheck supports pre-waiving.")
public class CheckOVM23a
extends OVMComplianceCheck {
    public CheckOVM23a(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String libAnalysisPortName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_analysis_port");
        RfClass baseMonitor = this.fOVMProject.fOvmMonitor;
        if (baseMonitor == null) {
            return;
        }
        HashSet<RfClass> visited = new HashSet<RfClass>();
        visited.add(baseMonitor);
        this.checkChildMonitors(baseMonitor, libAnalysisPortName, visited);
    }

    private void checkChildMonitors(RfClass monitor, String libAnalysisPortName, Set<RfClass> visited) {
        boolean found = false;
        this.notifyCheckAlive();
        if (monitor.getChildren() == null) {
            return;
        }
        for (RfClass childMonitor : monitor.getChildren()) {
            if (visited.contains(childMonitor)) continue;
            visited.add(childMonitor);
            found = this.checkIfMonitorImplementsAnalysisPort(childMonitor, libAnalysisPortName);
            if (!(this.checkPreWaivers(childMonitor.getFile()) || childMonitor.hasVirtualQualifier() || found)) {
                this.addHit(childMonitor, String.valueOf(libAnalysisPortName) + " is not implemented in monitor '" + childMonitor.getName() + "'!");
            }
            if (found) continue;
            this.checkChildMonitors(childMonitor, libAnalysisPortName, visited);
        }
    }

    private boolean checkIfMonitorImplementsAnalysisPort(RfClass monitor, String libAnalysisPortName) {
        List<RfField> fields = monitor.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (fields == null) {
            return false;
        }
        for (RfField field : fields) {
            RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
            if (fieldType == null || !libAnalysisPortName.equals(fieldType.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

