/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="3.1")
@CheckID(value="XVM23b")
@CheckName(value="XVM23b")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.MONITOR, RuleLabel.ANALYSIS_PORT, RuleLabel.CLASS_INSTANTIATION, RuleLabel.VERIFICATION})
@CheckTitle(value="Monitor's Analysis Ports Instantiation")
@CheckDescription(value="Monitor's xvm_analysis_ports should be constructed only in the specified functions.\n\nCheck supports pre-waiving")
public class CheckOVM23b
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="new, build, build_phase", description="Comma separated list of method names, check that xvm_analysis_ports are constructed only in methods with these names.", name="allowedMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pAllowedMethods;

    public CheckOVM23b(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fMonitors.isEmpty()) {
            return;
        }
        String libAnalysisPortName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_analysis_port");
        for (RfClass monitor : this.fOVMProject.fMonitors.values()) {
            RfDefElement declaration = monitor.getDeclaration();
            if (declaration == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(declaration.getParserPath(), this)) continue;
            this.notifyCheckAlive();
            HashSet<RfFunction> allowedMethods = new HashSet<RfFunction>();
            for (String methodName : this.pAllowedMethods) {
                RfFunction function = null;
                function = methodName.equals("new") ? monitor.getConstructorWithPrefix("new", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE) : monitor.getFunctionWithPrefix(methodName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                if (function == null) {
                    function = monitor.getTaskWithPrefix(methodName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                }
                if (function == null) continue;
                allowedMethods.add(function);
            }
            List<RfField> fields = monitor.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (fields == null) continue;
            for (RfField field : fields) {
                RfClass fieldType;
                if (field == null || (fieldType = LintUtils.getFieldFinalClassTypeOrNull(field)) == null || !libAnalysisPortName.equals(fieldType.getName())) continue;
                boolean foundInMethod = false;
                for (RfFunction method : allowedMethods) {
                    if (!this.isFieldConstructedInsideFunction(field, method)) continue;
                    foundInMethod = true;
                    break;
                }
                if (foundInMethod) continue;
                this.addHit(field, "The '" + field.getName() + "' " + libAnalysisPortName + " is not constructed in any of the specified methods of monitor '" + monitor.getName() + "'!");
            }
        }
    }

    private boolean isFieldConstructedInsideFunction(RfField aField, RfFunction aInsideFunction) {
        if (aInsideFunction == null || aField == null) {
            return false;
        }
        ConstructorCallsVisitor constructorCallsVisitor = new ConstructorCallsVisitor(aField);
        aInsideFunction.visitHidObject(null, constructorCallsVisitor);
        return constructorCallsVisitor.getFoundPortConstructor();
    }

    private static class ConstructorCallsVisitor
    extends RfHidVisitor {
        RfField field;
        boolean foundPortConstructor;

        public ConstructorCallsVisitor(RfField field) {
            this.field = field;
            this.foundPortConstructor = false;
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            if (element.isPredefined()) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            if (!function.isConstructor()) {
                return true;
            }
            if (!(hidObject.getParentHid() instanceof RfHid)) {
                return true;
            }
            if (!(hidObject.getParentHid().getElement() instanceof RfField)) {
                return true;
            }
            if ((RfField)hidObject.getParentHid().getElement() == this.field) {
                this.foundPortConstructor = true;
                return false;
            }
            return true;
        }

        public boolean getFoundPortConstructor() {
            return this.foundPortConstructor;
        }
    }
}

