/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.HashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.standard.checks.CheckOVM51;

@CheckVersion(value="3.1")
@CheckID(value="XVM28")
@CheckName(value="XVM28")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.DRIVER, RuleLabel.SEQUENCER, RuleLabel.CLASS_INSTANTIATION, RuleLabel.AGENT, RuleLabel.CONDITIONAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Conditional Driver and Sequencer Instantiation in Agent")
@CheckDescription(value="In every agent check the existence of conditional code using a variable of type xvm_active_passive_enum, \nand verify the correct component creation/instantiation for driver and sequencer only if the configuration is active.\n\nNote: Properly instantiated means that they should be created using class_name::type_id::create() method inside the build phase function. Please see the example in rule XVM51.\n\nRelated checks: ARAD, ARAI, ARMI, ARDI, ARSI, ARAS, XVM51, XVM52, XVM60.\n\nImplementation details:\nFor each agent (skips virtual agents):\nFor each driver or sequencer field (excluding inheritance, skips fields of virtual type):\n1) Checks that there are create() calls inside the build phase function. The create() calls are field_type::type_id::create(). Other types that inherit from field_type may be used.\nFor each create() call:\n2) Checks that the call is assigned to the field.\n3) Checks that the call is guarded by an \"if(get_is_active())\" or \"if(get_is_active() == XVM_ACTIVE)\" or \"if(XVM_ACTIVE == get_is_active())\" or \"if(<expr of active_passive_enum type>)\"\n\n Unlike ARDI and ARSI, this rule checks that each agent properly instantiates a driver and a sequencer. You should use all of them to be on the safe side, even if there is some redundancy.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="allowInstantiationByActiveFieldChecking", description="When true, a connection can be established if it is guarded by conditional code that checks if a field is of type xvm_active_passive_enum", isVisible=true), @CheckParameterOverride(name="testbenchClassNamePattern", isVisible=false)})
@CheckReapplyDisable
public class CheckOVM28
extends CheckOVM51 {
    public CheckOVM28(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.pushMethodsArguments = new HashSet();
        this.checkComponentCreation(this.fOVMProject.fAgents, this.fOVMProject.fSequencers, this.fOVMProject.fOvmSequencer, "sequencer");
        this.checkComponentCreation(this.fOVMProject.fAgents, this.fOVMProject.fDrivers, this.fOVMProject.fOvmDriver, "driver");
    }

    @Override
    protected boolean checkIfInConditionalCode() {
        return true;
    }
}

