/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;

@CheckVersion(value="3.1")
@CheckID(value="XVM3")
@CheckName(value="XVM3")
@CheckLabel(labels={RuleLabel.CONSTRUCTOR, RuleLabel.SUPER, RuleLabel.CLASS, RuleLabel.VERIFICATION})
@CheckTitle(value="Mandatory constructor calling super.new()")
@CheckDescription(value="Verify the existence of the new() constructor for all classes extended from xvm_*, like xvm_sequence_item, xvm_test, xvm_env, xvm_driver, etc.\nThe constructor must call super.new().\n\nCheck supports pre-waiving.")
public class CheckOVM3
extends OVMComplianceCheck {
    private Map<RfClass, Boolean> visitedClasses;
    @CheckParameter(defaultValue="false", description="When true, virtual classes are skipped.", name="skipVirtualClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipVirtualClasses;

    public CheckOVM3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String libPrefix = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_");
        this.visitedClasses = new HashMap<RfClass, Boolean>();
        for (RfNamedElement elem : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(elem.getFile()) || this.hasOnlyStaticMembers(elem) || !((RfClass)elem).isSubClass(libPrefix, false) || this.isVirtualOrChildOfVoid((RfClass)elem)) continue;
            RfFunction constructor = elem.getConstructorWithPrefix("new", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (constructor == null || constructor instanceof RfPredefinedFunction) {
                this.addHit(elem, "'" + elem.getFullName() + ".new()' is missing!");
                continue;
            }
            List<RfFunctionCall> functionCalls = constructor.getFunctionCallsWithPrefix("super.new", 1);
            if (functionCalls == null || functionCalls.isEmpty()) {
                this.addHit(constructor, "'" + elem.getFullName() + ".new()' doesn't call 'super.new()'!");
                continue;
            }
            this.addPassedHit(functionCalls.get(0), "'" + elem.getFullName() + ".new()' exists and calls 'super.new()'.");
        }
    }

    private boolean hasOnlyStaticMembers(RfNamedElement elem) {
        if (!(elem instanceof RfClass)) {
            return true;
        }
        RfClass clazz = (RfClass)elem;
        RfClass parentClass = clazz.getParent();
        if (parentClass instanceof RfSpecializedClass) {
            parentClass = ((RfSpecializedClass)parentClass).getGenericClass();
        }
        Boolean isStatic = true;
        while (parentClass != null) {
            if (this.visitedClasses.containsKey(parentClass)) {
                isStatic = this.visitedClasses.get(parentClass);
                if (isStatic.booleanValue()) break;
                this.visitedClasses.put(clazz, isStatic);
                return isStatic;
            }
            isStatic = isStatic != false && this.hasOnlyStaticMembers(parentClass);
            parentClass = parentClass.getParent();
        }
        if (!isStatic.booleanValue()) {
            this.visitedClasses.put(clazz, isStatic);
            return isStatic;
        }
        Collection<RfNamedElement> classMembers = clazz.getMembers();
        for (RfNamedElement classMember : classMembers) {
            if (classMember.isPredefined() || classMember instanceof RfField && ((RfField)classMember).isAnyParameter() || classMember instanceof RfFunction && ((RfFunction)classMember).isConstructor() || classMember instanceof RfTypeAlias || classMember.hasObjectStaticQualifier()) continue;
            isStatic = false;
            break;
        }
        this.visitedClasses.put(clazz, isStatic);
        return isStatic;
    }

    private boolean isVirtualOrChildOfVoid(RfClass classs) {
        if (this.pSkipVirtualClasses && classs.isVirtual()) {
            return true;
        }
        return classs.getParent() != null && classs.getParent().getFullName().equals("uvm_pkg::uvm_void");
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

