/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.XVMLintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;

@CheckVersion(value="3.1")
@CheckID(value="XVM30a")
@CheckName(value="XVM30a")
@CheckLabel(labels={RuleLabel.AGENT, RuleLabel.CONNECT_PHASE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Agent Connect Phase")
@CheckDescription(value="In every agent check the existence of the connect phase method and inside it the existence of conditional code using a field or method call of type xvm_active_passive_enum.\n\nImplementation details:\nFor each agent (skips virtual agents):\n1) Check that the agent has a connect phase.\n2) Check that the method contains a conditional block.\n3) If <allowInstantiationByActiveFieldCheckingCheck> is true then check that the conditional block field type is one of <conditionalExpressionEnums>.\n4) Check that the conditional block expression contains either an equality or inequality operator.\n5) Check that one of the operands is of type <conditionalExpressionEnums> and contains 'ACTIVE' or 'PASSIVE' in their name.")
@CheckReapplyDisable
public class CheckOVM30a
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, a connection can be established if it is guarded by conditional code that checks if a field is of type xvm_active_passive_enum", name="allowInstantiationByActiveFieldChecking", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowInstantiationByActiveFieldChecking;
    @CheckParameter(defaultValue="xvm_active_passive_enum", description="Comma separated list of conditional expression field or method types.", name="conditionalExpressionEnums", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pConditionalExpressionEnums;

    public CheckOVM30a(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fAgents.isEmpty()) {
            return;
        }
        for (RfClass agent : this.fOVMProject.fAgents.values()) {
            this.notifyCheckAlive();
            if (agent.hasVirtualQualifier() || this.isValidAgent(agent)) continue;
            RfClass firstParentWithoutProperConnect = this.getParentWithoutProperConnect(agent);
            List<RfFunction> connectMethods = agent.getFunctionsWithPrefix(this.fOVMProject.getConnectPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (connectMethods == null || connectMethods.isEmpty()) {
                this.addHit(agent, this.getErrorMessage(agent, firstParentWithoutProperConnect));
                continue;
            }
            RfActionBlock block = XVMLintUtils.findActiveConditionalCodeInMethod(this.fOVMProject, connectMethods.get(0), agent, this.pAllowInstantiationByActiveFieldChecking, this.pConditionalExpressionEnums);
            if (block != null) continue;
            this.addHit(connectMethods.get(0), "Requested conditional code missing in '" + this.fOVMProject.getConnectPhaseMethodName() + "()' function of agent '" + agent.getName() + "'!");
        }
    }

    private String getErrorMessage(RfClass agent, RfClass firstParentWithoutConnect) {
        StringBuilder result = new StringBuilder("'" + this.fOVMProject.getConnectPhaseMethodName() + "()' function missing in agent '" + agent.getName() + "'!");
        if (firstParentWithoutConnect == null) {
            return result.toString();
        }
        List<RfFunction> connectMethods = firstParentWithoutConnect.getFunctionsWithPrefix(this.fOVMProject.getConnectPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (connectMethods == null || connectMethods.isEmpty()) {
            return result.toString();
        }
        RfActionBlock block = XVMLintUtils.findActiveConditionalCodeInMethod(this.fOVMProject, connectMethods.get(0), firstParentWithoutConnect, this.pAllowInstantiationByActiveFieldChecking, this.pConditionalExpressionEnums);
        if (block == null) {
            result.append("\nInherited '" + this.fOVMProject.getConnectPhaseMethodName() + "()' function from agent '" + this.link(firstParentWithoutConnect) + "' is missing requested conditional code!");
        }
        return result.toString();
    }

    private RfClass getParentWithoutProperConnect(RfClass agent) {
        RfClass result = null;
        agent = agent.getParent();
        while (agent != null) {
            if (agent.isPredefined() || this.fOVMProject.isOVMElement(agent)) {
                return result;
            }
            if (!this.hasConnectMethod(agent)) {
                result = agent;
            }
            agent = agent.getParent();
        }
        return result;
    }

    private boolean isValidAgent(RfClass agent) {
        while (agent != null) {
            if (agent.isPredefined() || this.fOVMProject.isOVMElement(agent)) break;
            if (agent instanceof RfSpecializedClass) {
                agent = agent.getGenericClass();
            }
            if (this.hasConnectMethod(agent)) {
                return true;
            }
            agent = agent.getParent();
        }
        return false;
    }

    private boolean hasConnectMethod(RfClass agent) {
        List<RfFunction> connectMethods = agent.getFunctionsWithPrefix(this.fOVMProject.getConnectPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (connectMethods == null || connectMethods.isEmpty()) {
            return false;
        }
        RfActionBlock block = XVMLintUtils.findActiveConditionalCodeInMethod(this.fOVMProject, connectMethods.get(0), agent, this.pAllowInstantiationByActiveFieldChecking, this.pConditionalExpressionEnums);
        return block != null;
    }
}

