/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.XVMLintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="3.1")
@CheckID(value="XVM30b")
@CheckName(value="XVM30b")
@CheckLabel(labels={RuleLabel.CONNECT_PHASE, RuleLabel.AGENT, RuleLabel.VIRTUAL_INTERFACE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Agent Connect Phase - Virtual Interface Connection")
@CheckDescription(value="In every agent, if conditional code is used verify the correct connection of virtual interface for monitor and driver, \nand optionally even for sequencer (rare, but sometime used).\n\nThis check will pass iff:\n1) there is a virtual interface field in the agent (e.g. xsi)\n2) there is an assignment to the corresponding driver/monitor field\nFor example:\nclass xbus_slave_agent extends xvm_agent;\n...\n  virtual xbus_if xsi;// need this\n...\n  function void connect();// need this\n    monitor.xsi = xsi; // need this\n    if(is_active == XVM_ACTIVE) begin // need this\n      driver.seq_item_port.connect(sequencer.seq_item_export);\n      sequencer.addr_ph_port.connect(monitor.addr_ph_imp);\n      driver.xsi = xsi; // need this\n    end\n  endfunction\n...\n\nCheck supports pre-waiving.")
public class CheckOVM30b
extends OVMComplianceCheck {
    public CheckOVM30b(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fAgents.isEmpty()) {
            return;
        }
        for (RfClass agent : this.fOVMProject.fAgents.values()) {
            List<RfField> allFields;
            List<RfFunction> connectMethods;
            if (this.checkPreWaivers(agent.getFile()) || (connectMethods = agent.getFunctionsWithPrefix(this.fOVMProject.getConnectPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) == null || connectMethods.isEmpty() || (allFields = agent.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) == null || allFields.isEmpty()) continue;
            this.notifyCheckAlive();
            RfField driver = null;
            RfField sequencer = null;
            RfField monitor = null;
            RfClass driverType = null;
            RfClass sequencerType = null;
            RfClass monitorType = null;
            for (RfField field : allFields) {
                RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
                if (fieldType == null) continue;
                if (driver == null && this.fOVMProject.isDriver(fieldType)) {
                    driver = field;
                    driverType = fieldType;
                    continue;
                }
                if (sequencer == null && this.fOVMProject.isSequencer(fieldType)) {
                    sequencer = field;
                    sequencerType = fieldType;
                    continue;
                }
                if (monitor != null || !this.fOVMProject.isMonitor(fieldType)) continue;
                monitor = field;
                monitorType = fieldType;
            }
            RfActionBlock conditionalBlock = XVMLintUtils.findActiveConditionalCodeInMethod(this.fOVMProject, connectMethods.get(0), agent);
            if (conditionalBlock == null) continue;
            RfField agentVif = null;
            List<RfField> agentVifs = XVMLintUtils.getVirtualInterfaceFieldsInClass(agent, 2);
            if (agentVifs != null && !agentVifs.isEmpty()) {
                agentVif = agentVifs.get(0);
            }
            if (monitor != null && monitorType != null) {
                this.checkVifConnection(agentVif, connectMethods.get(0), monitor, monitorType, true);
            }
            if (driver != null && driverType != null) {
                this.checkVifConnection(agentVif, conditionalBlock, driver, driverType, true);
            }
            if (sequencer == null || sequencerType == null) continue;
            this.checkVifConnection(agentVif, conditionalBlock, sequencer, sequencerType, false);
        }
    }

    private void checkVifConnection(RfField agentVif, RfNamedElement connectionScope, RfField componentField, RfClass component, boolean failIfNoConnection) {
        if (agentVif == null) {
            if (failIfNoConnection) {
                this.addHit(connectionScope, "Virtual interface not connected for '" + component.getName() + "'!");
            }
            return;
        }
        List<RfField> componentVifs = XVMLintUtils.getVirtualInterfaceFieldsInClass(component, 2);
        if (componentVifs == null || componentVifs.isEmpty()) {
            if (failIfNoConnection) {
                this.addHit(component, "'" + component.getName() + "' has no virtual interface field!");
            }
            return;
        }
        RfField componentVif = componentVifs.get(0);
        LocalHidOperatorVisitor operatorVisitor = new LocalHidOperatorVisitor(agentVif, componentField, componentVif);
        connectionScope.visitHidObject(null, (IHidVisitor<?>)operatorVisitor);
        if (!operatorVisitor.isFound() && failIfNoConnection) {
            this.addHit(connectionScope, "Virtual interface not connected for '" + component.getName() + "'!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private static class LocalHidOperatorVisitor
    extends HidOperatorVisitor {
        RfField agentVif;
        RfField componentField;
        RfField componentVif;
        boolean found;

        public LocalHidOperatorVisitor(RfField agentVif, RfField componentField, RfField componentVif) {
            super(null);
            this.agentVif = agentVif;
            this.componentField = componentField;
            this.componentVif = componentVif;
            this.found = false;
        }

        public boolean visit(HidOperator operator) {
            if (!operator.isAssignment()) {
                return true;
            }
            IHidObject lhObject = operator.getLHValue();
            if (operator.getRHValues() == null || operator.getRHValues().size() != 1) {
                return true;
            }
            IHidObject rhObject = (IHidObject)operator.getRHValues().get(0);
            if (!(lhObject instanceof RfHid) || !(rhObject instanceof RfHid)) {
                return true;
            }
            RfHid lhHid = (RfHid)lhObject;
            RfHid rhHid = (RfHid)rhObject;
            if (rhHid.getElement() instanceof RfModport && rhHid.getParentAccess() != null && rhHid.getParentHid() instanceof RfHid) {
                rhHid = (RfHid)rhHid.getParentHid();
            }
            if (!rhHid.getElement().equals(this.agentVif)) {
                return true;
            }
            if (rhHid.getParentAccess() != null && rhHid.getParentHid().getName() != null && !rhHid.getParentHid().getName().equals("this")) {
                return true;
            }
            if (!lhHid.getElement().equals(this.componentVif)) {
                return true;
            }
            if (lhHid.getParentAccess() != null && lhHid.getParentHid().getElement() != null && !lhHid.getParentHid().getElement().equals(this.componentField)) {
                return true;
            }
            if (!(lhHid.getParentHid() instanceof RfHid)) {
                return true;
            }
            RfHid lhParentHid = (RfHid)lhHid.getParentHid();
            if (lhParentHid.getParentAccess() != null && lhParentHid.getParentHid().getName() != null && !lhParentHid.getParentHid().getName().equals("this")) {
                return true;
            }
            this.found = true;
            return true;
        }

        public boolean isFound() {
            return this.found;
        }
    }
}

