/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.linter.utils.XVMLintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.11")
@CheckID(value="XVM30c")
@CheckName(value="XVM30c")
@CheckLabel(labels={RuleLabel.CONNECT_PHASE, RuleLabel.AGENT, RuleLabel.DRIVER, RuleLabel.SEQUENCER, RuleLabel.METHOD, RuleLabel.TLM_PORT, RuleLabel.VERIFICATION})
@CheckTitle(value="Agent Connect Phase - Driver to Sequencer Connection")
@CheckDescription(value="In the connect_phase() of the agent, connect the driver port to the sequencer export when agent is active.\nCheck that connect_phase exists and check that the sequencer and the driver are connected.\n\nThis check will pass iff:\n1) there is a connect_phase() in the agent\n2) inside the connect_phase() all the drivers and all the sequencers are connected accordingly, guarded by conditional code using a variable of type xvm_active_passive_enum\nFor example:\nclass xbus_slave_agent extends xvm_agent;\n...\n  function void connect_phase();\n    if(is_active == XVM_ACTIVE) begin\n      driver.seq_item_port.connect(sequencer.seq_item_export);\n    end\n  endfunction\n...\n\nCheck supports pre-waiving.")
public class CheckOVM30c
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, a connection can be established if it is guarded by conditional code that checks the active field from a configuration class", name="allowInstantiationByActiveFieldChecking", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowInstantiationByActiveFieldChecking;
    private Set<RfField> usedDrivers = new HashSet<RfField>();
    private Set<RfField> usedSequencers = new HashSet<RfField>();
    private String connectMethodFullName;

    public CheckOVM30c(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.usedDrivers.clear();
        this.usedSequencers.clear();
        if (this.fOVMProject.fAgents.isEmpty()) {
            return;
        }
        String packageName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg");
        String portBaseName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_port_base");
        this.connectMethodFullName = String.valueOf(packageName) + "::" + portBaseName + ".connect";
        for (RfClass agent : this.fOVMProject.fAgents.values()) {
            List<RfField> fields;
            RfDefElement declaration = agent.getDeclaration();
            if (declaration != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(declaration.getParserPath(), this) || (fields = agent.getFields()) == null || fields.isEmpty()) continue;
            this.notifyCheckAlive();
            HashSet<RfField> drivers = new HashSet<RfField>();
            HashSet<RfField> sequencers = new HashSet<RfField>();
            for (RfField field : fields) {
                RfClass fieldClassType = LintUtils.getFieldFinalClassTypeOrNull(field);
                if (fieldClassType == null) continue;
                if (this.isDriver(fieldClassType)) {
                    drivers.add(field);
                    continue;
                }
                if (!this.isSequencer(fieldClassType)) continue;
                sequencers.add(field);
            }
            if (drivers.isEmpty() || sequencers.isEmpty()) continue;
            RfFunction connectPhaseMethod = agent.getFunctionWithPrefix(this.fOVMProject.getConnectPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (connectPhaseMethod == null) {
                this.reportErrors(drivers, sequencers);
                continue;
            }
            ConnectPhaseMethodVisitor visitor = new ConnectPhaseMethodVisitor();
            connectPhaseMethod.visitHidObject(this.fOVMProject.getRfProject(), visitor);
            drivers.removeAll(this.usedDrivers);
            sequencers.removeAll(this.usedSequencers);
            this.reportErrors(drivers, sequencers);
        }
    }

    private void reportErrors(Set<RfField> drivers, Set<RfField> sequencers) {
        for (RfField driver : drivers) {
            this.addHit(driver, "'" + LintUtils.getNamedElementFullName(driver) + " is not connected using connect() inside the" + this.fOVMProject.getConnectPhaseMethodName() + "() method!");
        }
        for (RfField sequencer : sequencers) {
            this.addHit(sequencer, "'" + LintUtils.getNamedElementFullName(sequencer) + " is not connected using connect() inside the" + this.fOVMProject.getConnectPhaseMethodName() + "() method!");
        }
    }

    private boolean isDriver(RfClass fieldClassType) {
        return fieldClassType.isSubClass(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_driver"), true);
    }

    private boolean isSequencer(RfClass fieldClassType) {
        return fieldClassType.isSubClass(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_sequencer"), true);
    }

    private class ConnectPhaseMethodVisitor
    implements IHidVisitor<RfHidAccessArgs> {
        private IRfNamedElement scope;

        private ConnectPhaseMethodVisitor() {
        }

        public void setHolder(IHidHolder holder) {
            if (holder instanceof RfHidHolder) {
                this.scope = ((RfHidHolder)holder).getScope();
            }
        }

        public boolean visit(RfHidAccessArgs accessArgs) {
            Hid accessParentHid = accessArgs.getParentHid();
            if (accessParentHid == null || accessParentHid.getName() == null) {
                return true;
            }
            if (!this.isConnectMethod(accessParentHid)) {
                return true;
            }
            List<? extends IHidObject> argumentValues = accessArgs.getArgumentValues();
            if (argumentValues == null || argumentValues.size() != 1) {
                return true;
            }
            Hid parentHid = accessArgs.getParentHid();
            RfField sequencer = this.solveSequencer(argumentValues.get(0));
            RfField driver = this.solveDriver((IHidObject)parentHid);
            if (sequencer == null || driver == null) {
                return true;
            }
            RfClass sequencerType = LintUtils.getFieldFinalClassTypeOrNull(sequencer);
            RfClass driverType = LintUtils.getFieldFinalClassTypeOrNull(driver);
            if (sequencerType == null || driverType == null) {
                return true;
            }
            if (!(this.scope instanceof RfNamedElement)) {
                return true;
            }
            boolean isInsideGoodIf = this.checkEnclosingScopeIsValidConditional(this.scope, CheckOVM30c.this.pAllowInstantiationByActiveFieldChecking);
            if (CheckOVM30c.this.isSequencer(sequencerType) && CheckOVM30c.this.isDriver(driverType)) {
                if (!isInsideGoodIf) {
                    CheckOVM30c.this.addHit(this.scope.getDeclaration().getParserPath(), accessArgs.getOccurrence(), "Driver port of '" + LintUtils.getNamedElementFullName(driver) + "' is not connected to sequencer export of '" + LintUtils.getNamedElementFullName(sequencer) + "' in a proper conditional code!");
                }
                CheckOVM30c.this.usedDrivers.add(driver);
                CheckOVM30c.this.usedSequencers.add(sequencer);
            }
            return true;
        }

        private boolean checkEnclosingScopeIsValidConditional(IRfNamedElement enclosingScope, boolean allowInstantiationByActiveFieldChecking) {
            while (enclosingScope != null && enclosingScope instanceof RfActionBlock) {
                if (((RfActionBlock)enclosingScope).isConditional()) {
                    RfActionBlock block = (RfActionBlock)enclosingScope;
                    if (XVMLintUtils.isActiveConditionalBlock(CheckOVM30c.this.fOVMProject, block, allowInstantiationByActiveFieldChecking)) {
                        return true;
                    }
                }
                enclosingScope = ((RfNamedElement)enclosingScope).getEnclosingScope();
            }
            return false;
        }

        private boolean isConnectMethod(Hid accessParentHid) {
            if (!accessParentHid.getName().equals("connect")) {
                return false;
            }
            IRfNamedElement element = accessParentHid.getElement();
            if (element == null || !(element instanceof RfFunction)) {
                return false;
            }
            return CheckOVM30c.this.connectMethodFullName.equals(((RfNamedElement)element).getFullName());
        }

        private RfField solveDriver(IHidObject parentHid) {
            if (!(parentHid instanceof RfHid)) {
                return null;
            }
            RfHid hid = (RfHid)parentHid;
            Hid portHid = hid.getParentHid();
            if (portHid == null || !(portHid instanceof RfHid)) {
                return null;
            }
            IRfNamedElement port = portHid.getElement();
            if (port == null || !(port instanceof RfField)) {
                return null;
            }
            if (!port.getName().equals("seq_item_port")) {
                return null;
            }
            Hid driverHid = portHid.getParentHid();
            if (driverHid == null || !(driverHid instanceof RfHid)) {
                return null;
            }
            IRfNamedElement driver = driverHid.getElement();
            if (driver == null || !(driver instanceof RfField)) {
                return null;
            }
            RfClass type = LintUtils.getFieldFinalClassTypeOrNull((RfField)driver);
            if (type != null && CheckOVM30c.this.isDriver(type)) {
                return (RfField)driver;
            }
            return null;
        }

        private RfField solveSequencer(IHidObject argumentValue) {
            if (!(argumentValue instanceof RfHidOperator)) {
                return null;
            }
            RfHidOperator operator = (RfHidOperator)argumentValue;
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return null;
            }
            IHidObject argumentForConnect = (IHidObject)rhValues.get(0);
            if (!(argumentForConnect instanceof RfHid)) {
                return null;
            }
            IRfNamedElement element = ((RfHid)argumentForConnect).getElement();
            if (element == null || !(element instanceof RfField)) {
                return null;
            }
            if (!element.getName().equals("seq_item_export")) {
                return null;
            }
            Hid sequencerHid = ((RfHid)argumentForConnect).getParentHid();
            if (sequencerHid == null || !(sequencerHid instanceof RfHid)) {
                return null;
            }
            IRfNamedElement sequencer = sequencerHid.getElement();
            if (sequencer == null || !(sequencer instanceof RfField)) {
                return null;
            }
            RfClass type = LintUtils.getFieldFinalClassTypeOrNull((RfField)sequencer);
            if (type != null && CheckOVM30c.this.isSequencer(type)) {
                return (RfField)sequencer;
            }
            return null;
        }

        public Class<RfHidAccessArgs> getType() {
            return RfHidAccessArgs.class;
        }
    }
}

