/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="XVM36")
@CheckName(value="XVM36")
@CheckLabel(labels={RuleLabel.CHECKING, RuleLabel.INTERFACE, RuleLabel.ASSERTION, RuleLabel.VERIFICATION})
@CheckTitle(value="Interface Protocol Checking")
@CheckDescription(value="In the interface declaration at least one protocol checking assertion should be implemented.")
public class CheckOVM36
extends OVMComplianceCheck {
    public CheckOVM36(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement elm : this.fOVMProject.getAllInterfaces()) {
            this.notifyCheckAlive();
            boolean found = false;
            List<RfAssertExpect> assertExpects = elm.getAssertsExpectsWithPrefix("", 2, 1);
            if (assertExpects != null) {
                for (RfAssertExpect assExp : assertExpects) {
                    if (!assExp.isAssert()) continue;
                    this.addPassedHit(assExp, "'" + assExp.getName() + "' - protocol checking assertion found in interface '" + elm.getName() + "'");
                    found = true;
                }
            }
            if (found) continue;
            this.addHit(elm, "Protocol checking assertion not found in interface '" + elm.getName() + "'");
        }
    }
}

