/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractNamePatternParametersCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="3.1")
@CheckID(value="XVM4")
@CheckName(value="XVM4")
@CheckLabel(labels={RuleLabel.BASE_CLASS, RuleLabel.UVM_SEQUENCE, RuleLabel.CLASS, RuleLabel.VERIFICATION})
@CheckTitle(value="Sequence Inherits from xvm_sequence")
@CheckDescription(value="The declaration of a sequence or virtual sequence class is derived from xvm_sequence or a derivative of xvm_sequence.")
@CheckParameterOverride(name="sequenceNamePattern", isVisible=true)
public class CheckOVM4
extends AbstractNamePatternParametersCheck {
    public CheckOVM4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.getClassesWithPatterns("sequenceNamePattern").isEmpty()) {
            return;
        }
        if (this.fOVMProject.fOvmSequence == null) {
            return;
        }
        for (RfClass clazz : this.getClassesWithPatterns("sequenceNamePattern").values()) {
            this.notifyCheckAlive();
            if (LintUtils.isSubClassOf(clazz, this.fOVMProject.fOvmSequence)) {
                this.addPassedHit(clazz, "'" + clazz.getName() + "' extends '" + this.fOVMProject.fOvmSequence.getName() + "'");
                continue;
            }
            this.addHit(clazz, "'" + clazz.getName() + "' does not extend '" + this.fOVMProject.fOvmSequence.getName() + "'");
        }
    }
}

