/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractNamePatternParametersCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="3.1")
@CheckID(value="XVM45")
@CheckName(value="XVM45")
@CheckLabel(labels={RuleLabel.BASE_CLASS, RuleLabel.TESTBENCH, RuleLabel.ENVIRONMENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Testbench Inherits from xvm_env")
@CheckDescription(value="The class declaring the testbench is extended from xvm_env.\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="testbenchClassNamePattern", isVisible=true)
public class CheckOVM45
extends AbstractNamePatternParametersCheck {
    @CheckParameter(defaultValue="xvm_pkg::xvm_env", description="Check if all testbenches inherit from 'baseClass'.", name="baseClass", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    protected String pBaseClassValue;

    public CheckOVM45(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.getClassesWithPatterns("testbenchClassNamePattern").isEmpty()) {
            return;
        }
        RfClass baseClass = this.getBaseClass();
        if (baseClass == null) {
            if (!this.pBaseClassValue.isEmpty()) {
                this.signalParamError("Class '" + this.pBaseClassValue + "' not found!", false);
            }
            return;
        }
        for (RfClass clazz : this.getClassesWithPatterns("testbenchClassNamePattern").values()) {
            if (this.checkPreWaivers(clazz.getFile()) || clazz.equals(baseClass)) continue;
            this.notifyCheckAlive();
            if (LintUtils.isSubClassOf(clazz, baseClass)) continue;
            this.addHit(clazz, "'" + clazz.getName() + "' does not extend '" + baseClass.getName() + "'");
        }
    }

    protected RfClass getBaseClass() {
        if (!this.pBaseClassValue.isEmpty()) {
            return this.fOVMProject.getRfProject().getClass(this.pBaseClassValue, true);
        }
        return this.fOVMProject.fOvmEnv;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

