/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.standard.checks.AbstractBuildPhaseCreationCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="3.1")
@CheckID(value="XVM46")
@CheckName(value="XVM46")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.TESTBENCH, RuleLabel.ENVIRONMENT, RuleLabel.CLASS_INSTANTIATION, RuleLabel.VERIFICATION})
@CheckTitle(value="Testbench Instantiates environment")
@CheckDescription(value="The testbench class instantiates one or more envs.\nException: Virtual testbenches are skipped.\nRelated checks: ARAD, ARAI, ARMI, ARDI, ARSI, ARAS, XVM28, XVM49, XVM51, XVM52, XVM60.\n\nNote: Properly instantiated means that they should be created using class_name::type_id::create() method inside the build phase.\nSee the example in rule XVM51.\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
@CheckParameterOverride(name="testbenchClassNamePattern", isVisible=true)
public class CheckOVM46
extends AbstractBuildPhaseCreationCheck {
    public CheckOVM46(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.shouldSkip = false;
    }

    @Override
    protected Collection<RfClass> getClasses() {
        return this.getClassesWithPatterns("testbenchClassNamePattern").values();
    }

    @Override
    protected Set<RfField> getFields(RfClass classs) {
        HashSet<RfField> fields = new HashSet<RfField>();
        List<RfField> candidates = classs.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (candidates != null && !candidates.isEmpty()) {
            for (RfField field : candidates) {
                RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
                if (fieldType == null || !this.fOVMProject.isEnv(fieldType)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    @Override
    public void addMissingFieldHit(RfClass classs) {
        this.addHit(classs, "Testbench '" + classs.getName() + "' does not instantiate any env");
    }

    @Override
    public void addNotProperlyInstantiatedFieldHit(RfClass classs, RfField field) {
        this.addHit(field, "Env '" + LintUtils.getFieldFinalClassTypeOrNull(field).getName() + "' is not properly instantiated in testbench '" + classs.getName() + "'");
    }

    @Override
    public void addInstantiationOutsideFunctionHit(ParserPath parserPath, IRfNamedElement element, RfHid hid) {
        this.addHit(parserPath, hid, "Env '" + element.getName() + "' is instantiated outside a function!");
    }

    @Override
    public void addInstantiationOutsideBuildPhaseHit(ParserPath parserPath, IRfNamedElement element, RfHid hid) {
        this.addHit(parserPath, hid, "Env '" + element.getName() + "' is instantiated out of a " + this.fOVMProject.getBuildPhaseMethodName() + "() method");
    }

    @Override
    protected boolean checkElementType(RfClass rightElement) {
        return this.fOVMProject.isEnv(rightElement);
    }
}

