/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.standard.checks.AbstractBuildPhaseCreationCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="3.1")
@CheckID(value="XVM49")
@CheckName(value="XVM49")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.TEST, RuleLabel.TESTBENCH, RuleLabel.CLASS_INSTANTIATION, RuleLabel.VERIFICATION})
@CheckTitle(value="Test Instantiates Testbench")
@CheckDescription(value="The test class must instantiate the testbench(sve).\nException: Virtual tests are skipped.\nRelated checks: ARAD, ARAI, ARMI, ARDI, ARSI, ARAS, XVM28, XVM49, XVM51, XVM52, XVM60.\n\nNote: Properly instantiated means that they should be created using class_name::type_id::create() method inside the build phase.\nSee the example in rule XVM51.\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
@CheckParameterOverride(name="testbenchClassNamePattern", isVisible=true)
public class CheckOVM49
extends AbstractBuildPhaseCreationCheck {
    public CheckOVM49(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.shouldSkip = false;
    }

    @Override
    protected Collection<RfClass> getClasses() {
        if (this.getClassesWithPatterns("testbenchClassNamePattern").isEmpty()) {
            return null;
        }
        return this.fOVMProject.fTests.values();
    }

    @Override
    protected Set<RfField> getFields(RfClass classs) {
        HashSet<RfField> fields = new HashSet<RfField>();
        List<RfField> candidates = classs.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (candidates != null && !candidates.isEmpty()) {
            for (RfField field : candidates) {
                RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
                if (fieldType == null || !this.getClassesWithPatterns("testbenchClassNamePattern").containsKey(fieldType.getFullName())) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    @Override
    public void addMissingFieldHit(RfClass classs) {
        this.addHit(classs, "Test class '" + classs.getName() + "' does not instantiate any testbench");
    }

    @Override
    public void addNotProperlyInstantiatedFieldHit(RfClass classs, RfField field) {
        this.addHit(field, "Testbench '" + LintUtils.getFieldFinalClassTypeOrNull(field).getName() + "' is not properly instantiated in test class '" + classs.getName() + "'");
    }

    @Override
    public void addInstantiationOutsideFunctionHit(ParserPath parserPath, IRfNamedElement element, RfHid hid) {
        this.addHit(parserPath, hid, "Testbench '" + element.getName() + "' is instantiated outside a function!");
    }

    @Override
    public void addInstantiationOutsideBuildPhaseHit(ParserPath parserPath, IRfNamedElement element, RfHid hid) {
        this.addHit(parserPath, hid, "Testbench '" + element.getName() + "' is instantiated out of a " + this.fOVMProject.getBuildPhaseMethodName() + "() method");
    }

    @Override
    protected boolean checkElementType(RfClass rightElement) {
        return this.getClassesWithPatterns("testbenchClassNamePattern").containsValue(rightElement);
    }
}

