/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;

@CheckVersion(value="3.1")
@CheckID(value="XVM50")
@CheckName(value="XVM50")
@CheckLabel(labels={RuleLabel.MONITOR, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Monitor begin_tr, end_tr")
@CheckDescription(value="In every monitor check the usage of begin_tr, end_tr.\n\nCheck supports pre-waiving.")
public class CheckOVM50
extends OVMComplianceCheck {
    public CheckOVM50(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fMonitors.isEmpty()) {
            return;
        }
        for (RfClass monitor : this.fOVMProject.fMonitors.values()) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(monitor.getFile())) continue;
            List<RfFunction> functionsAndTasks = monitor.getFunctionsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            functionsAndTasks.addAll(monitor.getTasksWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
            boolean beginTrFound = false;
            boolean endTrFound = false;
            for (RfFunction fun : functionsAndTasks) {
                List<RfFunctionCall> beginFunctionCalls = fun.getFunctionCallsWithPrefix("this.begin_tr", 1);
                beginFunctionCalls.addAll(fun.getFunctionCallsWithPrefix("begin_tr", 1));
                if (!beginFunctionCalls.isEmpty()) {
                    beginTrFound = true;
                }
                List<RfFunctionCall> endFunctionCalls = fun.getFunctionCallsWithPrefix("this.end_tr", 1);
                endFunctionCalls.addAll(fun.getFunctionCallsWithPrefix("end_tr", 1));
                if (endFunctionCalls.isEmpty()) continue;
                endTrFound = true;
            }
            if (!beginTrFound && !endTrFound) {
                this.addHit(monitor, "Monitor '" + monitor.getName() + "' does not call begin_tr() and end_tr() methods");
                continue;
            }
            if (!beginTrFound) {
                this.addHit(monitor, "Monitor '" + monitor.getName() + "' does not call begin_tr() method");
                continue;
            }
            if (endTrFound) continue;
            this.addHit(monitor, "Monitor '" + monitor.getName() + "' does not call end_tr() method");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

