/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractNamePatternParametersCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.XVMLintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="3.1")
@CheckID(value="XVM51")
@CheckName(value="XVM51")
@CheckLabel(labels={RuleLabel.FACTORY_CREATE, RuleLabel.COMPONENT, RuleLabel.BUILD_PHASE, RuleLabel.VERIFICATION})
@CheckTitle(value="Create components in the build phase")
@CheckDescription(value="All VC components such as driver, monitor, sequencer, agent, env, etc. must be created using the create call inside the build phase method.\n\nRelated checks: ARAD, ARAI, ARMI, ARDI, ARSI, ARAS, XVM28, XVM46, XVM49, XVM60.\n\nExample:\nclass xbus_master_agent extends xvm_agent;\n  xbus_master_driver driver;\n  xbus_master_sequencer sequencer;\n  xbus_master_monitor monitor;\n  ...\n  function void build_phase();\n    super.build_phase();\n    monitor = xbus_master_monitor::type_id::create(\"monitor\", this);\n    if(get_is_active() == XVM_ACTIVE) begin // or if(is_active ==... \n      sequencer = xbus_master_sequencer::type_id::create(\"sequencer\", this);\n      driver = xbus_master_driver::type_id::create(\"driver\", this);\n    end\n    ...\n  endfunction : build_phase\nendclass\n\nImplementation details:\n0) First it checks that you have at least a component in each category.\nFor each \"uvm container\" (e.g. agent, skips virtual components):\nFor each field that can be \"uvm contained\" (e.g. driver can be contained in agent) (excluding inheritance, skips fields of virtual type):\n1) Checks that there is at least one create() call inside the build phase. The create() call is \"field_type::type_id::create()\". Other types that inherit from field_type may be used.\n2) Checks that this call is assigned to the field.")
@CheckReapplyDisable
@CheckParameterOverride(name="testbenchClassNamePattern", isVisible=true)
public class CheckOVM51
extends AbstractNamePatternParametersCheck {
    protected Set<RfHidAccessArgs> pushMethodsArguments;
    @CheckParameter(defaultValue="false", description="When true, the create call is allowed in a function called from the build phase.", name="allowIndirectCallInstantiation", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowIndirectCallInstantiationValue;
    @CheckParameter(defaultValue="false", description="When true, casting the result of the create() call is accepted: $cast(m_comp, create_component(...)).", name="allowCastOnComponent", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowCastOnComponentValue;
    @CheckParameter(defaultValue="false", description="When true, a local variable may be used to hold the value of the create call and subsequently assign it to the field.", name="allowTempVariableAssigning", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowTempVariableAssigning;
    @CheckParameter(defaultValue="false", description="When true, a reference argument of a method may be used to assign the value of the create call, if the method call is called directly or indirectly from the build phase with the component field.\nIMPORTANT:\nThis parameter is only enforced when the <allowIndirectCallInstantiation> is enabled as well.", name="allowRefArgumentInstantiation", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowRefArgumentInstantiation;
    @CheckParameter(defaultValue="false", description="", name="allowInstantiationByActiveFieldChecking", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN, isVisible=false)
    protected boolean pAllowInstantiationByActiveFieldChecking;

    public CheckOVM51(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.pushMethodsArguments = new HashSet<RfHidAccessArgs>();
        this.checkComponentCreation(this.fOVMProject.fTests, this.getClassesWithPatterns("testbenchClassNamePattern"), this.fOVMProject.fOvmEnv, "testbench");
        this.checkComponentCreation(this.getClassesWithPatterns("testbenchClassNamePattern"), this.fOVMProject.fEnvs, this.fOVMProject.fOvmEnv, "env");
        this.checkComponentCreation(this.fOVMProject.fEnvs, this.fOVMProject.fAgents, this.fOVMProject.fOvmAgent, "agent");
        this.checkComponentCreation(this.fOVMProject.fAgents, this.fOVMProject.fAgents, this.fOVMProject.fOvmAgent, "agent");
        this.checkComponentCreation(this.fOVMProject.fEnvs, this.fOVMProject.fMonitors, this.fOVMProject.fOvmMonitor, "monitor");
        this.checkComponentCreation(this.fOVMProject.fAgents, this.fOVMProject.fMonitors, this.fOVMProject.fOvmMonitor, "monitor");
        this.checkComponentCreation(this.fOVMProject.fAgents, this.fOVMProject.fSequencers, this.fOVMProject.fOvmSequencer, "sequencer");
        this.checkComponentCreation(this.fOVMProject.fAgents, this.fOVMProject.fDrivers, this.fOVMProject.fOvmDriver, "driver");
    }

    protected void checkComponentCreation(Map<String, RfClass> containers, Map<String, RfClass> elements, RfClass baseClass, String baseClassName) {
        if (containers == null || elements == null) {
            return;
        }
        if (baseClass == null) {
            this.addHit(null, "No " + baseClassName + " base class was found.");
            return;
        }
        for (RfClass container : containers.values()) {
            this.handleClass(container, elements, baseClass);
        }
    }

    private void handleClass(RfClass container, Map<String, RfClass> elements, RfClass baseClass) {
        if (container.hasVirtualQualifier()) {
            return;
        }
        List<RfField> fields = container.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (fields == null || fields.isEmpty()) {
            return;
        }
        this.notifyCheckAlive();
        RfFunction buildFunction = container.getFunctionWithPrefix(this.fOVMProject.getBuildPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (buildFunction != null) {
            buildFunction.visitHidObject(null, new PushMethodsVisitor(this.pushMethodsArguments, new HashSet<RfFunction>(), container));
        }
        HashSet<RfField> filteredFields = new HashSet<RfField>();
        for (RfField field : fields) {
            RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field, RfTypesResolver.create((IRfScopeElement)container, container.getRfProject(), 6));
            if (fieldType == null || !elements.containsKey(fieldType.getFullName()) || fieldType.hasVirtualQualifier()) continue;
            if (buildFunction == null && field.getDataType() != null) {
                this.addHit(field, "'" + field.getDataType().getTypeNameWithParamAssignments() + "' is not created using create() inside the " + this.fOVMProject.getBuildPhaseMethodName() + "() method!");
                continue;
            }
            filteredFields.add(field);
        }
        if (buildFunction == null || filteredFields.isEmpty()) {
            return;
        }
        Set<RfField> fieldsWithCreateCall = this.findCallsInBuildFunction(buildFunction, baseClass, filteredFields, new HashSet<RfFunction>(), container);
        for (RfField field : filteredFields) {
            if (fieldsWithCreateCall.contains(field)) continue;
            this.addHit(field, "'" + field.getDataType().getTypeNameWithParamAssignments() + "' is not created using create() inside the " + this.fOVMProject.getBuildPhaseMethodName() + "() method!");
        }
    }

    private Set<RfField> findCallsInBuildFunction(RfFunction buildFunction, RfClass baseClass, Set<RfField> filteredFields, Set<RfFunction> visitedFunctions, RfClass container) {
        HashSet<RfField> fieldsWithCreateCall = new HashSet<RfField>();
        if (buildFunction == null) {
            return fieldsWithCreateCall;
        }
        RfNamedElement scope = buildFunction.getEnclosingScope();
        if (!(scope instanceof RfClass)) {
            return fieldsWithCreateCall;
        }
        visitedFunctions.add(buildFunction);
        buildFunction.visitHidObject(this.fOVMProject.getRfProject(), new FunctionVisitor(fieldsWithCreateCall, visitedFunctions, filteredFields, new HashMap<RfField, Set<RfField>>(), (RfClass)scope, baseClass, false, container));
        if (this.pAllowTempVariableAssigning) {
            buildFunction.visitHidObject(this.fOVMProject.getRfProject(), new AssignmentVisitor(filteredFields, fieldsWithCreateCall));
        }
        return fieldsWithCreateCall;
    }

    protected boolean checkIfInConditionalCode() {
        return false;
    }

    class AssignmentVisitor
    implements IHidVisitor<IHidOperator> {
        private Set<RfField> unassignedFields;
        private Set<RfField> assignedFields;

        public AssignmentVisitor(Set<RfField> unassignedFields, Set<RfField> assignedFields) {
            this.unassignedFields = unassignedFields;
            this.assignedFields = assignedFields;
        }

        public boolean visit(IHidOperator hidOperator) {
            if (!hidOperator.isAssignment()) {
                return true;
            }
            IHidObject lhValue = hidOperator.getLHValue();
            if (!(lhValue instanceof RfHid)) {
                return true;
            }
            IRfNamedElement lhElement = ((RfHid)lhValue).getElement();
            if (!(lhElement instanceof RfField)) {
                return true;
            }
            RfField leftField = (RfField)lhElement;
            IHidObject rightHidObj = hidOperator.getFirstRHValue();
            if (!(rightHidObj instanceof RfHid)) {
                return true;
            }
            RfHid rightHid = (RfHid)rightHidObj;
            while (rightHid.getParentHid() != null && rightHid.getParentHid() instanceof RfHid) {
                rightHid = (RfHid)rightHid.getParentHid();
            }
            IRfNamedElement rhElement = rightHid.getElement();
            if (!(rhElement instanceof RfField)) {
                return true;
            }
            RfField rightField = (RfField)rhElement;
            if (!this.assignedFields.contains(rightField)) {
                return true;
            }
            this.unassignedFields.remove(leftField);
            return true;
        }

        public Class<IHidOperator> getType() {
            return IHidOperator.class;
        }
    }

    private final class FunctionVisitor
    implements IHidVisitor<IHidObject> {
        private Set<RfField> fieldsWithCreateCall;
        private Set<RfFunction> visitedFunctions;
        private Set<RfField> filteredFields;
        private Map<RfField, Set<RfField>> fieldsUsedAsRefArguments;
        private RfClass functionClass;
        private RfClass baseClass;
        private IHidHolder holder;
        private ParserPath parserPath;
        private boolean isInConditional;
        private RfClass container;

        public FunctionVisitor(Set<RfField> fieldsWithCreateCall, Set<RfFunction> visitedFunctions, Set<RfField> filteredFields, Map<RfField, Set<RfField>> fieldsUsedAsRefArguments, RfClass functionClass, RfClass baseClass, boolean isInConditional, RfClass container) {
            this.fieldsWithCreateCall = fieldsWithCreateCall;
            this.filteredFields = filteredFields;
            this.visitedFunctions = visitedFunctions;
            this.fieldsUsedAsRefArguments = fieldsUsedAsRefArguments;
            this.functionClass = functionClass;
            this.baseClass = baseClass;
            this.isInConditional = isInConditional;
            this.container = container;
        }

        public void setHolder(IHidHolder holder) {
            this.holder = holder;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(IHidObject hidObject) {
            if (hidObject instanceof RfHidOperator) {
                RfHidOperator operator = (RfHidOperator)hidObject;
                return this.visitOperator(operator);
            }
            if (hidObject instanceof RfHid) {
                RfHid hid = (RfHid)hidObject;
                return this.visitHid(hid);
            }
            return true;
        }

        private boolean visitOperator(RfHidOperator operator) {
            if (!operator.isEqualAssignment()) {
                return true;
            }
            RfField left = this.getFieldFromAssignment(operator);
            if (left == null) {
                return true;
            }
            RfHidAccess access = this.getAccessFromAssignment(left, operator, this.container);
            if (access == null) {
                return true;
            }
            this.fieldsWithCreateCall.add(left);
            if (CheckOVM51.this.checkIfInConditionalCode() && !this.isInConditional) {
                if (this.checkHolderIsActive(this.holder)) {
                    return true;
                }
                HidOccurrence occurence = access.getOccurrence();
                if (occurence == null) {
                    return true;
                }
                if (left.getDataType() == null) {
                    return true;
                }
                CheckOVM51.this.addHit(this.parserPath, occurence.getLine(), "'" + left.getName() + "' of type '" + left.getDataType().getTypeNameWithParamAssignments() + "' is not created in a proper conditional code!", null);
            }
            return true;
        }

        private boolean visitHid(RfHid hid) {
            boolean skipCheckingIfVisited;
            RfFunction tempFunction;
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction localFunction = (RfFunction)element;
            if (localFunction.getName().equals("push_back") || localFunction.getName().equals("push_front")) {
                if (!(localFunction instanceof RfPredefinedFunction)) {
                    return true;
                }
                ListContainer access = hid.getAccesses();
                HidAccess first = (HidAccess)access.get(0);
                if (!(first instanceof RfHidAccessArgs)) {
                    return true;
                }
                RfHidAccessArgs args = (RfHidAccessArgs)first;
                Hid parent = args.getParentHid();
                if (parent == null) {
                    return true;
                }
                HidAccess fieldAccess = parent.getParentAccess();
                if (!(fieldAccess instanceof RfHidAccess)) {
                    return true;
                }
                Hid fieldHid = fieldAccess.getParentHid();
                if (!(fieldHid instanceof RfHid)) {
                    return true;
                }
                IRfNamedElement field = fieldHid.getElement();
                if (!(field instanceof RfField)) {
                    return true;
                }
                return this.analyzePushCalls(args, (RfField)field);
            }
            if (CheckOVM51.this.pAllowCastOnComponentValue && localFunction.getName().equals("$cast")) {
                ListContainer access = hid.getAccesses();
                HidAccess first = (HidAccess)access.get(0);
                if (!(first instanceof RfHidAccessArgs)) {
                    return true;
                }
                RfHidAccessArgs args = (RfHidAccessArgs)first;
                return this.analyzeCastCalls(args);
            }
            if (!CheckOVM51.this.pAllowIndirectCallInstantiationValue) {
                return true;
            }
            if (localFunction.isPredefined()) {
                return true;
            }
            if (localFunction.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(localFunction, hid, this.functionClass)) != null) {
                localFunction = tempFunction;
            }
            boolean bl = skipCheckingIfVisited = CheckOVM51.this.pAllowRefArgumentInstantiation && this.hasRefArguments(localFunction);
            if (!skipCheckingIfVisited && this.visitedFunctions.contains(localFunction)) {
                return true;
            }
            this.visitedFunctions.add(localFunction);
            boolean tempIsInConditional = this.isInConditional;
            if (CheckOVM51.this.checkIfInConditionalCode() && !tempIsInConditional) {
                tempIsInConditional = this.checkHolderIsActive(this.holder);
            }
            if (CheckOVM51.this.pAllowRefArgumentInstantiation) {
                for (MethodCall methodCall : MethodCallUtils.getMethodCalls((IHid)hid)) {
                    if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) continue;
                    for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                        IRfNamedElement argumentElement;
                        IRfFieldElement key = (IRfFieldElement)entry.getKey();
                        IHidObject value = (IHidObject)entry.getValue();
                        if (!(key instanceof RfField) || !(value instanceof RfHid)) continue;
                        RfField argument = (RfField)key;
                        RfHid argumentValue = (RfHid)value;
                        if (!argument.isArgument() || !argument.isRef() || !((argumentElement = argumentValue.getElement()) instanceof RfField)) continue;
                        if (!this.fieldsUsedAsRefArguments.containsKey(argument)) {
                            this.fieldsUsedAsRefArguments.put(argument, new HashSet());
                        }
                        RfField argumentField = (RfField)argumentElement;
                        if (this.fieldsUsedAsRefArguments.get(argument).contains(argumentField)) {
                            return true;
                        }
                        this.fieldsUsedAsRefArguments.get(argument).add(argumentField);
                    }
                }
            }
            localFunction.visitHidObject(CheckOVM51.this.fOVMProject.getRfProject(), new FunctionVisitor(this.fieldsWithCreateCall, this.visitedFunctions, this.filteredFields, this.fieldsUsedAsRefArguments, this.functionClass, this.baseClass, tempIsInConditional, this.container));
            if (CheckOVM51.this.pAllowTempVariableAssigning) {
                localFunction.visitHidObject(CheckOVM51.this.fOVMProject.getRfProject(), new AssignmentVisitor(this.filteredFields, this.fieldsWithCreateCall));
            }
            if (CheckOVM51.this.pAllowRefArgumentInstantiation) {
                HashSet<RfField> fieldsToAdd = new HashSet<RfField>();
                for (RfField fieldWithCreateCall : this.fieldsWithCreateCall) {
                    Set<RfField> argumentValues;
                    if (!fieldWithCreateCall.isArgument() || !fieldWithCreateCall.isRef() || (argumentValues = this.fieldsUsedAsRefArguments.get(fieldWithCreateCall)) == null) continue;
                    fieldsToAdd.addAll(argumentValues);
                }
                this.fieldsWithCreateCall.addAll(fieldsToAdd);
            }
            return true;
        }

        private boolean analyzePushCalls(RfHidAccessArgs args, RfField field) {
            List<? extends IHidObject> argumentValues = args.getArgumentValues();
            if (argumentValues.size() != 1) {
                return true;
            }
            IHidObject arg = argumentValues.get(0);
            if (!(arg instanceof RfHidOperator)) {
                return true;
            }
            ListContainer rhValues = ((RfHidOperator)arg).getRHValues();
            if (rhValues.size() != 1) {
                return true;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            if (!(rhValue instanceof RfHidAccessArgs)) {
                return true;
            }
            RfHidAccessArgs accessArgs = (RfHidAccessArgs)rhValue;
            Hid parentHid = accessArgs.getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return true;
            }
            if (!parentHid.isMethodCall(false)) {
                return true;
            }
            String methodName = parentHid.getName();
            if (!methodName.equals("create")) {
                return true;
            }
            if (!((parentHid = parentHid.getParentHid()) instanceof RfHid)) {
                return true;
            }
            String typeName = parentHid.getName();
            if (!typeName.equals("type_id")) {
                return true;
            }
            if (!((parentHid = parentHid.getParentHid()) instanceof RfHid)) {
                return true;
            }
            IRfNamedElement element = parentHid.getElement();
            if (element instanceof RfField) {
                element = LintUtils.getFieldFinalClassTypeOrNull((RfField)element);
            }
            if (!(element instanceof RfClass)) {
                return true;
            }
            if (!LintUtils.isChildOf((RfClass)element, this.baseClass)) {
                return true;
            }
            if (CheckOVM51.this.pushMethodsArguments.contains((Object)accessArgs)) {
                this.fieldsWithCreateCall.add(field);
            }
            return true;
        }

        private boolean analyzeCastCalls(RfHidAccessArgs args) {
            List<? extends IHidObject> argumentValues = args.getArgumentValues();
            if (argumentValues.size() != 2) {
                return true;
            }
            IHidObject firstArg = argumentValues.get(0);
            IHidObject secondArg = argumentValues.get(1);
            if (!(firstArg instanceof RfHidOperator) || !(secondArg instanceof RfHidOperator)) {
                return true;
            }
            IHidObject firstLHValue = ((RfHidOperator)firstArg).getLHValue();
            IHidObject secondLHValue = ((RfHidOperator)secondArg).getLHValue();
            if (!(firstLHValue instanceof RfHidImplicit) || !(secondLHValue instanceof RfHidImplicit)) {
                return true;
            }
            RfHidOperator destinationOperator = (RfHidOperator)firstArg;
            RfHidOperator sourceOperator = (RfHidOperator)secondArg;
            if (((RfHidImplicit)firstLHValue).getName().equals("source_exp") && ((RfHidImplicit)secondLHValue).getName().equals("dest_var")) {
                destinationOperator = (RfHidOperator)secondArg;
                sourceOperator = (RfHidOperator)firstArg;
            }
            if (!destinationOperator.hasOccurrence(HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER)) {
                return true;
            }
            ListContainer rhValues = destinationOperator.getRHValues();
            if (rhValues.size() != 1) {
                return true;
            }
            IHidObject obj = (IHidObject)rhValues.get(0);
            if (obj instanceof RfHidAccess) {
                obj = ((RfHidAccess)obj).getParentHid();
            }
            if (!(obj instanceof RfHid)) {
                return true;
            }
            RfHid destinationHid = (RfHid)obj;
            IRfNamedElement destinationElement = destinationHid.getElement();
            if (!(destinationElement instanceof RfField)) {
                return true;
            }
            RfField destinationField = (RfField)destinationElement;
            if (!sourceOperator.hasOccurrence(HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER)) {
                return true;
            }
            ListContainer sourceRhValues = sourceOperator.getRHValues();
            if (sourceRhValues.size() != 1) {
                return true;
            }
            IHidObject source = (IHidObject)sourceRhValues.get(0);
            if (source instanceof RfHid) {
                RfHid sourceHid = (RfHid)source;
                IRfNamedElement sourceElement = sourceHid.getElement();
                if (!(sourceElement instanceof RfField)) {
                    return true;
                }
                if (this.fieldsWithCreateCall.contains(sourceElement)) {
                    RfClass sourceElementType = LintUtils.getFieldFinalClassTypeOrNull((RfField)sourceElement);
                    if (!LintUtils.isChildOf(sourceElementType, this.baseClass)) {
                        return true;
                    }
                    this.fieldsWithCreateCall.add(destinationField);
                    return true;
                }
            } else if (source instanceof RfHidAccessArgs) {
                RfHidAccessArgs acessArgs = (RfHidAccessArgs)source;
                Hid parentHid = acessArgs.getParentHid();
                if (!(parentHid instanceof RfHid)) {
                    return true;
                }
                String methodName = parentHid.getName();
                if (!methodName.equals("create")) {
                    return true;
                }
                if (!((parentHid = parentHid.getParentHid()) instanceof RfHid)) {
                    return true;
                }
                String typeName = parentHid.getName();
                if (!typeName.equals("type_id")) {
                    return true;
                }
                if (!((parentHid = parentHid.getParentHid()) instanceof RfHid)) {
                    return true;
                }
                IRfNamedElement element = parentHid.getElement();
                if (element instanceof RfField) {
                    element = LintUtils.getFieldFinalClassTypeOrNull((RfField)element);
                }
                if (!(element instanceof RfClass)) {
                    return true;
                }
                if (!LintUtils.isChildOf((RfClass)element, this.baseClass)) {
                    return true;
                }
                this.fieldsWithCreateCall.add(destinationField);
                if (CheckOVM51.this.checkIfInConditionalCode() && !this.isInConditional) {
                    if (this.checkHolderIsActive(this.holder)) {
                        return true;
                    }
                    HidOccurrence occurence = acessArgs.getOccurrence();
                    if (occurence == null) {
                        return true;
                    }
                    if (destinationField.getDataType() == null) {
                        return true;
                    }
                    CheckOVM51.this.addHit(this.parserPath, occurence.getLine(), "'" + destinationField.getName() + "' of type '" + destinationField.getDataType().getTypeNameWithParamAssignments() + "' is not created in a proper conditional code!", null);
                }
            }
            return true;
        }

        private RfHidAccess getAccessFromAssignment(RfField field, RfHidOperator operator, RfClass container) {
            RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
            if (fieldType instanceof RfSpecializedClass) {
                fieldType = ((RfSpecializedClass)fieldType).getGenericClass();
            }
            if (fieldType == null) {
                return null;
            }
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return null;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            if (!(rhValue instanceof RfHidAccessArgs)) {
                return null;
            }
            RfHidAccessArgs args = (RfHidAccessArgs)rhValue;
            Hid parentHid = args.getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return null;
            }
            String methodName = parentHid.getName();
            if (!methodName.equals("create")) {
                return null;
            }
            if (!((parentHid = parentHid.getParentHid()) instanceof RfHid)) {
                return null;
            }
            String typeName = parentHid.getName();
            if (!typeName.equals("type_id")) {
                return null;
            }
            if (!((parentHid = parentHid.getParentHid()) instanceof RfHid)) {
                return null;
            }
            IRfNamedElement element = parentHid.getElement();
            if (element instanceof RfField) {
                element = LintUtils.getFieldFinalClassTypeOrNull((RfField)element, RfTypesResolver.create((IRfScopeElement)container, container.getRfProject(), 6));
            }
            if (element instanceof RfTypeAlias) {
                element = LintUtils.getAssociatedFinalType((RfTypeAlias)element);
            }
            if (!(element instanceof RfClass)) {
                return null;
            }
            if (!LintUtils.isChildOf((RfClass)element, this.baseClass)) {
                return null;
            }
            return args;
        }

        private RfField getFieldFromAssignment(RfHidOperator operator) {
            IHidObject left = operator.getLHValue();
            RfHid hid = null;
            if (left instanceof RfHidImplicit) {
                RfHidImplicit hidImplicit = (RfHidImplicit)left;
                String name = hidImplicit.getName();
                HidOperatorOccurrence occurence = operator.getOccurrence();
                int offset = occurence.getOffset();
                RfFileDef fileDef = CheckOVM51.this.fOVMProject.getRfProject().getFileDefUsingParserPath(this.parserPath);
                RfDefElement scope = fileDef.getScope(offset, true);
                ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
                scope.getElementsWithPrefix(result, name, 1, 1, true, IRfNamedElement.AccessModifier.SHOW_PRIVATE, new IRfElementFilter(){

                    public boolean validElement(IRfNamedElement candidate) {
                        return candidate instanceof RfField;
                    }

                    public int resultMaxSize() {
                        return 100;
                    }

                    public boolean allowEnumElement() {
                        return false;
                    }
                });
                if (result.isEmpty()) {
                    return null;
                }
                return (RfField)result.iterator().next();
            }
            if (left instanceof RfHidAccess) {
                hid = (RfHid)((RfHidAccess)left).getParentHid();
            } else if (left instanceof RfHid) {
                hid = (RfHid)left;
            }
            if (hid == null) {
                return null;
            }
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfField)) {
                return null;
            }
            return (RfField)element;
        }

        /*
         * Unable to fully structure code
         */
        public boolean checkHolderIsActive(IHidHolder holder) {
            if (!CheckOVM51.this.checkIfInConditionalCode()) {
                return true;
            }
            if (!(holder instanceof RfHidHolder)) {
                return false;
            }
            scope = ((RfHidHolder)holder).getScope();
            if (scope != null && scope instanceof RfNamedElement) ** GOTO lbl13
            return false;
lbl-1000:
            // 1 sources

            {
                if (((RfActionBlock)scope).isConditional()) {
                    block = (RfActionBlock)scope;
                    if (XVMLintUtils.isActiveConditionalBlock(CheckOVM51.access$1(CheckOVM51.this), block, CheckOVM51.this.pAllowInstantiationByActiveFieldChecking)) {
                        return true;
                    }
                }
                scope = ((RfNamedElement)scope).getEnclosingScope();
lbl13:
                // 2 sources

                ** while (scope != null && scope instanceof RfActionBlock)
            }
lbl14:
            // 1 sources

            return false;
        }

        private boolean hasRefArguments(RfFunction function) {
            for (IRfFieldElement arg : function.getArguments()) {
                if (!arg.isRef()) continue;
                return true;
            }
            return false;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }

    private static final class PushMethodsVisitor
    extends RfHidVisitor {
        private Set<RfHidAccessArgs> pushMethodsArgs;
        private Set<RfFunction> visited;
        private RfClass classs;

        public PushMethodsVisitor(Set<RfHidAccessArgs> pushMethodsArgs, Set<RfFunction> visited, RfClass classs) {
            this.pushMethodsArgs = pushMethodsArgs;
            this.visited = visited;
            this.classs = classs;
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (!(hidObject.getElement() instanceof RfPredefinedFunction)) {
                RfFunction tempFunction;
                if (!(hidObject.getElement() instanceof RfFunction)) {
                    return true;
                }
                RfFunction calledFunction = (RfFunction)hidObject.getElement();
                if (calledFunction.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(calledFunction, hidObject, this.classs)) != null) {
                    calledFunction = tempFunction;
                }
                if (this.visited.contains(calledFunction)) {
                    return true;
                }
                this.visited.add(calledFunction);
                PushMethodsVisitor pushMethodsVisitor = new PushMethodsVisitor(this.pushMethodsArgs, this.visited, this.classs);
                calledFunction.visitHidObject(null, pushMethodsVisitor);
                return true;
            }
            RfPredefinedFunction function = (RfPredefinedFunction)hidObject.getElement();
            if (!function.getName().equals("push_back") && !function.getName().equals("push_front")) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            for (MethodCall call : methodCalls) {
                String methodName;
                RfHidAccessArgs accessArgs;
                Hid parentHid;
                IHidObject argValue;
                Map.Entry argEntry;
                if (call.argumentValuesMapRaw == null || call.argumentValuesMap.entrySet().size() > 1 || (argEntry = call.argumentValuesMapRaw.entrySet().iterator().next()) == null || !((argValue = (IHidObject)argEntry.getValue()) instanceof RfHidAccessArgs) || !((parentHid = (accessArgs = (RfHidAccessArgs)argValue).getParentHid()) instanceof RfHid) || !parentHid.isMethodCall(false) || !(methodName = parentHid.getName()).equals("create")) continue;
                this.pushMethodsArgs.add(accessArgs);
            }
            return true;
        }
    }
}

