/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LintUtilsConstants;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="16.1.32")
@CheckID(value="XVM51b")
@CheckName(value="XVM51b")
@CheckLabel(labels={RuleLabel.FACTORY_CREATE, RuleLabel.METHOD, RuleLabel.COMPONENT, RuleLabel.VERIFICATION, RuleLabel.PHASE})
@CheckTitle(value="XVM factory create calls must occur during XVM phases")
@CheckDescription(value="All create calls for components must occur during the XVM phases of another component.\nCreate calls for objects are allowed in:\n - a component constructor\n - a sequence body() method\n - a reg adapter reg2bus() method\n - an object constructor (with the exception of sequences and reg adapters)\nThis ensures that there are no create calls before run_test() or in parallel with the XVM flow.\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class CheckOVM51b
extends OVMComplianceCheck {
    private Set<RfClass> visitedClasses;
    private OVMComplianceCheck check;
    private String fComponentClassFullName;
    private String fSequenceBaseClassFullName;
    private String fXVMPortBaseClassFullName;
    private String fRegAdapterClassFullName;
    private String fObjectClassFullName;
    private String fObjectWrapperClassName;
    private String fObjectRegistryClassName;
    private String fComponentRegistryClassName;
    private String fFactoryClassName;
    private String fComponentClassName;
    private String fSequenceBaseClassName;
    private String fXVMPortBaseClassName;
    private String fImplementationPortBaseClassName;
    private String fRegAdapterClassName;
    private String fObjectClassName;
    private static final String WRITE_METHOD = "write";
    private static final Set<String> OBJECT_CREATE_FUNCTION_NAMES = new HashSet<String>();
    private static final Set<String> COMPONENT_CREATE_FUNCTION_NAMES = new HashSet<String>();
    private RfClass componentClass;
    private RfClass sequenceBaseClass;
    private RfClass xvmPortBaseClass;
    private RfClass regAdapterClass;
    private RfClass objectClass;
    private Set<String> enclosingClassNames;
    private Set<String> enclosingComponentClassNames;
    private Set<String> enclosingObjectClassNames;
    private Set<RfClass> implementationPortClasses;
    private Map<RfFunction, List<RfHid>> createComponentHidsByEnclosingFunction = new HashMap<RfFunction, List<RfHid>>();
    private Map<RfFunction, Set<RfFunction>> reverseComponentCallTree = new HashMap<RfFunction, Set<RfFunction>>();
    private Map<RfFunction, List<RfHid>> createObjectHidsByEnclosingFunction = new HashMap<RfFunction, List<RfHid>>();
    private Map<RfFunction, Set<RfFunction>> reverseObjectCallTree = new HashMap<RfFunction, Set<RfFunction>>();
    private Map<String, Set<RfFunction>> visitedFunctions = new HashMap<String, Set<RfFunction>>();
    @CheckParameter(defaultValue="false", description="When true, object create calls are allowed in the constructor of a sequence.", name="allowObjectCreateInSequenceConstructor", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowObjectCreateInSequenceConstructor;
    @CheckParameter(defaultValue="false", description="When true, object create calls are allowed in a sequence.", name="allowObjectCreateInSequence", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowObjectCreateInSequence;
    @CheckParameter(defaultValue="false", description="When true, calls from the following sequence methods are allowed: pre_start, pre_body, post_body, post_start, pre_do, mid_do, post_do.", name="allowObjectCreateInSequenceStartMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowObjectCreateInSequenceStartMethods;
    @CheckParameter(defaultValue="false", description="When true, object create calls are allowed from implementation port write methods.", name="allowObjectCreateInImplementationPortMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowObjectCreateInImplementationPortMethods;

    static {
        OBJECT_CREATE_FUNCTION_NAMES.add("create_object");
        OBJECT_CREATE_FUNCTION_NAMES.add("create_object_by_type");
        OBJECT_CREATE_FUNCTION_NAMES.add("create_object_by_name");
        COMPONENT_CREATE_FUNCTION_NAMES.add("create_component");
        COMPONENT_CREATE_FUNCTION_NAMES.add("create_component_by_type");
        COMPONENT_CREATE_FUNCTION_NAMES.add("create_component_by_name");
    }

    private void run() {
        HashSet<RfClass> visited;
        RfClass enclosingClass;
        this.visitedClasses = new HashSet<RfClass>();
        LocalHidVisitor visitor = new LocalHidVisitor(this.check);
        RfProject rfProject = this.fOVMProject.getRfProject();
        rfProject.visitHidObject(rfProject, visitor);
        if (this.createComponentHidsByEnclosingFunction.isEmpty() && this.createObjectHidsByEnclosingFunction.isEmpty()) {
            return;
        }
        HashSet<RfClass> enclosingClasses = new HashSet<RfClass>();
        for (RfFunction enclosingFunction : this.createComponentHidsByEnclosingFunction.keySet()) {
            enclosingClass = enclosingFunction.getEnclosingScope(RfClass.class);
            if (enclosingClass == null) continue;
            enclosingClasses.add(enclosingClass);
        }
        for (RfFunction enclosingFunction : this.createObjectHidsByEnclosingFunction.keySet()) {
            enclosingClass = enclosingFunction.getEnclosingScope(RfClass.class);
            if (enclosingClass == null) continue;
            enclosingClasses.add(enclosingClass);
        }
        for (RfClass clazz : enclosingClasses) {
            HashSet<RfClass> visited2 = new HashSet<RfClass>();
            if (clazz.isSubClass(this.componentClass)) {
                this.checkClass(clazz, CreateType.COMPONENT, true, visited2);
                continue;
            }
            if (!clazz.isSubClass(this.objectClass)) continue;
            this.checkClass(clazz, CreateType.OBJECT, true, visited2);
        }
        if (this.createComponentHidsByEnclosingFunction.isEmpty() && this.createObjectHidsByEnclosingFunction.isEmpty()) {
            return;
        }
        Set<RfClass> children = this.componentClass.getChildren();
        if (children != null) {
            for (RfClass rfClass : children) {
                visited = new HashSet<RfClass>();
                this.checkClass(rfClass, CreateType.COMPONENT, false, visited);
            }
        }
        for (Map.Entry entry : this.createComponentHidsByEnclosingFunction.entrySet()) {
            this.addHitsForCreateHid((RfNamedElement)entry.getKey(), (List)entry.getValue(), CreateType.COMPONENT);
        }
        if (this.createObjectHidsByEnclosingFunction.isEmpty()) {
            return;
        }
        children = this.objectClass.getChildren();
        if (children != null) {
            for (RfClass rfClass : children) {
                visited = new HashSet();
                this.checkClass(rfClass, CreateType.OBJECT, false, visited);
            }
        }
        for (Map.Entry entry : this.createObjectHidsByEnclosingFunction.entrySet()) {
            this.addHitsForCreateHid((RfNamedElement)entry.getKey(), (List)entry.getValue(), CreateType.OBJECT);
        }
    }

    private void checkClass(RfClass clazz, CreateType createType, boolean skipChildren, Set<RfClass> visited) {
        if (visited.contains(clazz)) {
            return;
        }
        visited.add(clazz);
        if (createType == CreateType.OBJECT && clazz.getFullName().equals(this.fComponentClassFullName)) {
            return;
        }
        if (!this.visitedClasses.contains(clazz)) {
            this.visitedClasses.add(clazz);
            if (!this.fOVMProject.isOVMElement(clazz)) {
                this.notifyCheckAlive();
                HashSet<RfFunction> functions = new HashSet<RfFunction>();
                functions.addAll(clazz.getFunctionsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
                functions.addAll(clazz.getTasksWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
                functions.addAll(clazz.getConstructorsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
                for (RfFunction function : functions) {
                    if (function.isPredefined() || this.fOVMProject.isOVMElement(function) || createType == CreateType.OBJECT && !this.isObjectCreateValidEnclosingMethod(function, null, clazz) || createType == CreateType.COMPONENT && !function.isConstructor() && !this.isPhaseMethod(function, null, clazz) && !this.isImplementationPortMethod(function, clazz)) continue;
                    HashMap<String, Set<RfFunction>> visitedObjectFunctions = new HashMap<String, Set<RfFunction>>();
                    HashSet<RfFunction> localFunction = new HashSet<RfFunction>();
                    localFunction.add(function);
                    visitedObjectFunctions.put(function.getFullName(), localFunction);
                    if (function.isConstructor() && createType == CreateType.COMPONENT) {
                        function.visitHidObject(this.fOVMProject.getRfProject(), new FunctionCallVisitor(visitedObjectFunctions, clazz, CreateType.OBJECT));
                        continue;
                    }
                    function.visitHidObject(this.fOVMProject.getRfProject(), new FunctionCallVisitor(visitedObjectFunctions, clazz, createType));
                }
            }
        }
        if (this.createComponentHidsByEnclosingFunction.isEmpty() && this.createObjectHidsByEnclosingFunction.isEmpty()) {
            return;
        }
        if (createType == CreateType.OBJECT && this.createObjectHidsByEnclosingFunction.isEmpty()) {
            return;
        }
        if (skipChildren) {
            return;
        }
        Set<RfClass> children = clazz.getChildren();
        if (children == null) {
            return;
        }
        for (RfClass child : children) {
            this.checkClass(child, createType, skipChildren, visited);
        }
    }

    public CheckOVM51b(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.createComponentHidsByEnclosingFunction.clear();
        this.createObjectHidsByEnclosingFunction.clear();
        this.reverseComponentCallTree.clear();
        this.reverseObjectCallTree.clear();
        this.visitedFunctions.clear();
        this.initializeClassNames();
        this.componentClass = this.fOVMProject.getRfProject().getClass(this.fComponentClassFullName, true);
        if (this.componentClass == null) {
            return;
        }
        this.sequenceBaseClass = this.fOVMProject.getRfProject().getClass(this.fSequenceBaseClassFullName, true);
        if (this.sequenceBaseClass == null) {
            return;
        }
        this.xvmPortBaseClass = this.fOVMProject.getRfProject().getClass(this.fXVMPortBaseClassFullName, true);
        this.implementationPortClasses = new HashSet<RfClass>();
        if (this.pAllowObjectCreateInImplementationPortMethods) {
            this.implementationPortClasses.addAll(this.xvmPortBaseClass.getChildren().stream().filter(c -> c.getName().contains("_analysis_imp") && this.isValidImplementationPortClass((RfClass)c, this.fImplementationPortBaseClassName)).collect(Collectors.toList()));
        }
        this.regAdapterClass = this.fOVMProject.getRfProject().getClass(this.fRegAdapterClassFullName, true);
        this.objectClass = this.fOVMProject.getRfProject().getClass(this.fObjectClassFullName, true);
        if (this.objectClass == null) {
            return;
        }
        this.run();
    }

    private boolean isValidImplementationPortClass(RfClass clazz, String basicImplementationPortName) {
        if (!clazz.getName().startsWith(basicImplementationPortName)) {
            return false;
        }
        if (clazz.getName().equals(basicImplementationPortName)) {
            return true;
        }
        RfDefElement declaration = clazz.getDeclaration();
        if (declaration == null) {
            return false;
        }
        ReparseInfo reparseInfo = declaration.getReparseInfo();
        if (reparseInfo == null) {
            return false;
        }
        String lastMacro = reparseInfo.getLastReparseMacroName();
        return lastMacro != null && lastMacro.equals(String.valueOf(basicImplementationPortName) + "_decl");
    }

    private void initializeClassNames() {
        this.fObjectRegistryClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object_registry");
        this.fComponentRegistryClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component_registry");
        this.fObjectWrapperClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object_wrapper");
        this.fFactoryClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_factory");
        this.fComponentClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component");
        this.fComponentClassFullName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + this.fComponentClassName;
        this.fSequenceBaseClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_sequence_base");
        this.fSequenceBaseClassFullName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + this.fSequenceBaseClassName;
        this.fXVMPortBaseClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_port_base");
        this.fXVMPortBaseClassFullName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + this.fXVMPortBaseClassName;
        this.fImplementationPortBaseClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_analysis_imp");
        this.fRegAdapterClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_reg_adapter");
        this.fRegAdapterClassFullName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + this.fRegAdapterClassName;
        this.fObjectClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object");
        this.fObjectClassFullName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + this.fObjectClassName;
        this.enclosingClassNames = new HashSet<String>();
        this.enclosingClassNames.add(this.fComponentClassName);
        this.enclosingClassNames.add(this.fObjectWrapperClassName);
        this.enclosingClassNames.add(this.fComponentRegistryClassName);
        this.enclosingClassNames.add(this.fObjectRegistryClassName);
        this.enclosingClassNames.add(this.fFactoryClassName);
        this.enclosingComponentClassNames = new HashSet<String>();
        this.enclosingComponentClassNames.add(this.fComponentClassName);
        this.enclosingComponentClassNames.add(this.fComponentRegistryClassName);
        this.enclosingObjectClassNames = new HashSet<String>();
        this.enclosingObjectClassNames.add(this.fObjectWrapperClassName);
        this.enclosingObjectClassNames.add(this.fObjectRegistryClassName);
    }

    private void addHitsForCreateHid(RfNamedElement function, List<RfHid> hids, CreateType createTypeFunction) {
        for (RfHid hid : hids) {
            Hid parentHid;
            String typeCreated = "";
            if (hid.getName().equals("create") && hid.getParentHid() != null && (parentHid = hid.getParentHid()).getParentHid() != null) {
                IRfNamedElement element = parentHid.getParentHid().getElement();
                if (element instanceof RfField && ((RfField)element).isTypeParameter()) {
                    element = ((RfAssociatedType)element).getAssociatedType(RfTypesResolver.create((IRfScopeElement)function, function.getRfProject(), 14));
                }
                if (element instanceof RfNamedElement) {
                    typeCreated = "'" + LintUtils.getNamedElementFullName((RfNamedElement)element) + "' ";
                }
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
            for (MethodCall methodCall : methodCalls) {
                if (createTypeFunction == CreateType.COMPONENT) {
                    this.addHit(function.getFile().getParserPath(), methodCall.occurrence, "Component " + typeCreated + "create is not called inside the phase of another component!");
                    continue;
                }
                this.addHit(function.getFile().getParserPath(), methodCall.occurrence, "Object " + typeCreated + "create is not inside a uvm_sequence.body(), uvm_reg_adapter.reg2bus() or another object/component constructor!");
            }
        }
    }

    private CreateType getCreateTypeFunction(RfFunction rfFunction) {
        if (rfFunction == null) {
            return CreateType.NONE;
        }
        String functionName = rfFunction.getName();
        if (!(COMPONENT_CREATE_FUNCTION_NAMES.contains(functionName) || OBJECT_CREATE_FUNCTION_NAMES.contains(functionName) || functionName.equals("create"))) {
            return CreateType.NONE;
        }
        RfNamedElement enclosingScope = rfFunction.getEnclosingScope();
        if (enclosingScope == null || !(enclosingScope instanceof RfClass)) {
            return CreateType.NONE;
        }
        RfClass enclosingClass = (RfClass)enclosingScope;
        if (functionName.equals("create")) {
            if (this.isSubClass(enclosingClass, this.enclosingComponentClassNames)) {
                return CreateType.COMPONENT;
            }
            if (this.isSubClass(enclosingClass, this.enclosingObjectClassNames)) {
                return CreateType.OBJECT;
            }
            return CreateType.NONE;
        }
        if (this.isSubClass(enclosingClass, this.enclosingClassNames)) {
            if (COMPONENT_CREATE_FUNCTION_NAMES.contains(functionName)) {
                return CreateType.COMPONENT;
            }
            return CreateType.OBJECT;
        }
        return CreateType.NONE;
    }

    private boolean isObjectCreateValidEnclosingMethod(RfFunction enclosingFunction, RfClass clazz, RfClass enclosingClass) {
        return this.isSequenceMethod(enclosingFunction, enclosingClass) || this.isPhaseMethod(enclosingFunction, clazz, enclosingClass) || this.isBodyMethod(enclosingFunction, clazz, enclosingClass) || this.isXVMConstructor(enclosingFunction, enclosingClass) || this.isReg2BusMethod(enclosingFunction, clazz, enclosingClass) || this.isSequenceStartMethod(enclosingFunction, enclosingClass) || this.isImplementationPortMethod(enclosingFunction, enclosingClass);
    }

    private boolean isSequenceMethod(RfFunction function, RfClass enclosingClass) {
        if (!this.pAllowObjectCreateInSequence) {
            return false;
        }
        if (function == null || enclosingClass == null) {
            return false;
        }
        return this.sequenceBaseClass == enclosingClass || enclosingClass.isSubClass(this.sequenceBaseClass);
    }

    private boolean isPhaseMethod(RfFunction function, RfClass clazz, RfClass enclosingClass) {
        if (function == null || enclosingClass == null) {
            return false;
        }
        if (this.fOVMProject.getLibraryKind() == 1 ? !LintUtilsConstants.OVM_COMPONENT_PHASES_NAMES.contains(function.getName()) : this.fOVMProject.getLibraryKind() == 2 && !LintUtilsConstants.UVM_COMPONENT_PHASES_NAMES.contains(function.getName())) {
            return false;
        }
        if (this.componentClass != enclosingClass && !enclosingClass.isSubClass(this.componentClass)) {
            return false;
        }
        if (clazz != null && clazz != enclosingClass) {
            RfFunction overridenFunction = null;
            if (function.isTask()) {
                overridenFunction = clazz.getTaskWithPrefix(function.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            } else if (function.isFunction()) {
                overridenFunction = clazz.getFunctionWithPrefix(function.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            if (overridenFunction != null) {
                return false;
            }
        }
        return true;
    }

    private boolean isBodyMethod(RfFunction function, RfClass clazz, RfClass enclosingClass) {
        RfFunction overridenFunction;
        if (function == null || enclosingClass == null) {
            return false;
        }
        if (!function.getName().equals("body")) {
            return false;
        }
        if (!this.sequenceBaseClass.equals(enclosingClass) && !enclosingClass.isSubClass(this.sequenceBaseClass)) {
            return false;
        }
        return clazz == null || clazz == enclosingClass || (overridenFunction = clazz.getTaskWithPrefix(function.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) == null;
    }

    private boolean isReg2BusMethod(RfFunction function, RfClass clazz, RfClass enclosingClass) {
        if (this.regAdapterClass == null) {
            return false;
        }
        if (function == null || !function.getName().equals("reg2bus") || enclosingClass == null) {
            return false;
        }
        if (this.regAdapterClass != enclosingClass && !enclosingClass.isSubClass(this.regAdapterClass)) {
            return false;
        }
        if (clazz != null && clazz != enclosingClass) {
            RfFunction overridenFunction = null;
            if (function.isTask()) {
                overridenFunction = clazz.getTaskWithPrefix(function.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            } else if (function.isFunction()) {
                overridenFunction = clazz.getFunctionWithPrefix(function.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            if (overridenFunction != null) {
                return false;
            }
        }
        return true;
    }

    private boolean isXVMConstructor(RfFunction function, RfClass enclosingClass) {
        if (function == null || !function.isConstructor() || enclosingClass == null) {
            return false;
        }
        return this.isObject(enclosingClass);
    }

    private boolean isSequenceStartMethod(RfFunction function, RfClass enclosingClass) {
        if (!this.pAllowObjectCreateInSequenceStartMethods) {
            return false;
        }
        if (function == null || enclosingClass == null) {
            return false;
        }
        if (this.sequenceBaseClass != enclosingClass && !enclosingClass.isSubClass(this.sequenceBaseClass)) {
            return false;
        }
        return LintUtilsConstants.SEQUENCE_START_FUNCTION_NAMES.contains(function.getName());
    }

    private boolean isImplementationPortMethod(RfFunction function, RfClass enclosingClass) {
        RfNamedElement valueT;
        if (!this.pAllowObjectCreateInImplementationPortMethods) {
            return false;
        }
        if (function == null || enclosingClass == null) {
            return false;
        }
        if (!function.getName().startsWith(WRITE_METHOD)) {
            return false;
        }
        List<RfField> arguments = function.getOnlyDeclarationArguments();
        if (arguments.size() != 1) {
            return false;
        }
        String suffix = function.getName().substring(WRITE_METHOD.length());
        Set<RfClass> searchedImplementationPortClasses = this.getClassesFromSet(this.implementationPortClasses, String.valueOf(this.fImplementationPortBaseClassName) + suffix);
        if (searchedImplementationPortClasses == null) {
            return false;
        }
        RfField implementationPortField = null;
        RfClass implementationPortFieldType = null;
        while (implementationPortField == null && enclosingClass != null) {
            List<RfField> enclosingClassFields = enclosingClass.getLocalFields();
            if (enclosingClassFields == null) {
                enclosingClass = enclosingClass.getParent();
                continue;
            }
            for (RfField field : enclosingClassFields) {
                RfClass genericFieldType;
                RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
                RfClass rfClass = genericFieldType = fieldType != null ? fieldType.getGenericClass() : null;
                if (!searchedImplementationPortClasses.contains(genericFieldType) || !(fieldType instanceof RfSpecializedClass)) continue;
                implementationPortField = field;
                implementationPortFieldType = (RfSpecializedClass)fieldType;
                break;
            }
            if (implementationPortField != null) continue;
            enclosingClass = enclosingClass.getParent();
        }
        if (implementationPortField == null || implementationPortFieldType == null) {
            return false;
        }
        IELParamValue parameterValueT = implementationPortFieldType.getElabConstantValue("T");
        if (parameterValueT == null) {
            return false;
        }
        RfNamedElement typeT = LintUtils.getAssociatedFinalType(arguments.get(0));
        RfNamedElement rfNamedElement = valueT = parameterValueT.getNamedElement() instanceof RfNamedElement ? (RfNamedElement)parameterValueT.getNamedElement() : null;
        if (!typeT.equals(valueT)) {
            return false;
        }
        IELParamValue parameterValueIMP = implementationPortFieldType.getElabConstantValue("IMP");
        if (parameterValueIMP == null) {
            return false;
        }
        IRfNamedElement valueIMP = parameterValueIMP.getNamedElement();
        if (!(valueIMP instanceof RfClass)) {
            return false;
        }
        RfClass classIMP = (RfClass)valueIMP;
        return LintUtils.isSubClassOf(enclosingClass, classIMP);
    }

    private Set<RfClass> getClassesFromSet(Set<RfClass> set, String name) {
        HashSet<RfClass> result = new HashSet<RfClass>();
        for (RfClass clazz : set) {
            if (!clazz.getName().equals(name)) continue;
            result.add(clazz);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    private boolean isObject(RfClass clazz) {
        RfClass parent = clazz;
        while (parent != null) {
            if (parent == this.objectClass) {
                return true;
            }
            if (parent == this.sequenceBaseClass) {
                return this.pAllowObjectCreateInSequenceConstructor;
            }
            if (this.regAdapterClass != null && parent == this.regAdapterClass) {
                return false;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public final boolean isSubClass(RfClass clazz, Set<String> classNames) {
        RfClass parent = clazz;
        while (parent != null) {
            if (classNames.contains(parent.getName())) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static enum CreateType {
        OBJECT,
        COMPONENT,
        NONE;

    }

    private final class FunctionCallVisitor
    implements IHidVisitor<RfHid> {
        private Map<String, Set<RfFunction>> visitedFunctions = new HashMap<String, Set<RfFunction>>();
        private RfClass functionClass;
        private CreateType createType;

        public FunctionCallVisitor(Map<String, Set<RfFunction>> visitedFunctions, RfClass functionClass, CreateType createType) {
            this.visitedFunctions = visitedFunctions;
            this.functionClass = functionClass;
            this.createType = createType;
        }

        public boolean visit(RfHid hidObject) {
            RfFunction tempFunction;
            if (CheckOVM51b.this.createObjectHidsByEnclosingFunction.isEmpty() && CheckOVM51b.this.createComponentHidsByEnclosingFunction.isEmpty()) {
                return false;
            }
            if (this.createType == CreateType.OBJECT && CheckOVM51b.this.createObjectHidsByEnclosingFunction.isEmpty()) {
                return false;
            }
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            RfClass methodCallScope = this.getMethodCallScope(hidObject);
            if (methodCallScope == null) {
                methodCallScope = this.functionClass;
            }
            if (function.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(function, hidObject, methodCallScope)) != null) {
                function = tempFunction;
            }
            if (this.createType == CreateType.COMPONENT && CheckOVM51b.this.createComponentHidsByEnclosingFunction.containsKey(function)) {
                CheckOVM51b.this.createComponentHidsByEnclosingFunction.remove(function);
            }
            if (CheckOVM51b.this.createObjectHidsByEnclosingFunction.containsKey(function)) {
                CheckOVM51b.this.createObjectHidsByEnclosingFunction.remove(function);
            }
            if (CheckOVM51b.this.fOVMProject.isOVMElement(function)) {
                return true;
            }
            Set<RfFunction> localFunctions = this.visitedFunctions.get(function.getFullName());
            if (localFunctions != null && localFunctions.contains(function)) {
                return true;
            }
            if (localFunctions == null) {
                localFunctions = new HashSet<RfFunction>();
                localFunctions.add(function);
                this.visitedFunctions.put(function.getFullName(), localFunctions);
            } else {
                localFunctions.add(function);
            }
            function.visitHidObject(CheckOVM51b.this.fOVMProject.getRfProject(), new FunctionCallVisitor(this.visitedFunctions, methodCallScope, this.createType));
            return true;
        }

        private RfClass getMethodCallScope(RfHid hidObject) {
            if (LintUtils.isSuper(hidObject)) {
                return null;
            }
            if (hidObject.getParentAccess() == null) {
                return null;
            }
            HidAccess parentAccess = hidObject.getParentAccess();
            if (parentAccess.getParentHid() == null) {
                return null;
            }
            Hid parentHid = parentAccess.getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return null;
            }
            IRfNamedElement parentElement = parentHid.getElement();
            if (!(parentElement instanceof RfAssociatedType)) {
                return null;
            }
            RfNamedElement parentElementType = LintUtils.getAssociatedFinalType((RfAssociatedType)parentElement);
            if (parentElementType instanceof RfClass) {
                return (RfClass)parentElementType;
            }
            return null;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }

    private class LocalHidVisitor
    extends RfHidVisitor {
        private OVMComplianceCheck check;

        public LocalHidVisitor(OVMComplianceCheck check) {
            this.check = check;
        }

        public boolean visit(RfHid hid) {
            if (CheckOVM51b.this.fOVMProject.getProjectWaivers().pathIsPrewaived(this.parserPath, this.check)) {
                return true;
            }
            if (hid == null) {
                return true;
            }
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            if (hidNamedElement.isPredefined()) {
                return true;
            }
            if (!(this.holder instanceof HidHolder)) {
                return true;
            }
            IRfNamedElement holderScope = ((HidHolder)this.holder).getScope();
            if (holderScope == null) {
                return true;
            }
            if (!(holderScope instanceof RfNamedElement)) {
                return true;
            }
            if (CheckOVM51b.this.fOVMProject.isOVMElement((RfNamedElement)holderScope)) {
                return true;
            }
            RfFunction enclosingFunction = (RfFunction)holderScope.getEnclosingScope(RfFunction.class);
            CheckOVM51b.this.notifyCheckAlive();
            CreateType createTypeFunction = CheckOVM51b.this.getCreateTypeFunction((RfFunction)hidNamedElement);
            if (createTypeFunction != CreateType.NONE) {
                if (enclosingFunction == null) {
                    CheckOVM51b.this.addHitsForCreateHid((RfNamedElement)holderScope, Arrays.asList(hid), createTypeFunction);
                    return true;
                }
                RfClass enclosingClass = enclosingFunction.getEnclosingScope(RfClass.class);
                if (enclosingClass != null) {
                    if (CheckOVM51b.this.isPhaseMethod(enclosingFunction, null, enclosingClass)) {
                        return true;
                    }
                    if (CheckOVM51b.this.isBodyMethod(enclosingFunction, null, enclosingClass) && createTypeFunction == CreateType.OBJECT) {
                        return true;
                    }
                    if (CheckOVM51b.this.isReg2BusMethod(enclosingFunction, null, enclosingClass) && createTypeFunction == CreateType.OBJECT) {
                        return true;
                    }
                    if (CheckOVM51b.this.isXVMConstructor(enclosingFunction, enclosingClass) && createTypeFunction == CreateType.OBJECT) {
                        return true;
                    }
                    if (CheckOVM51b.this.isSequenceMethod(enclosingFunction, enclosingClass) && createTypeFunction == CreateType.OBJECT) {
                        return true;
                    }
                    if (CheckOVM51b.this.isSequenceStartMethod(enclosingFunction, enclosingClass) && createTypeFunction == CreateType.OBJECT) {
                        return true;
                    }
                    if (CheckOVM51b.this.isImplementationPortMethod(enclosingFunction, enclosingClass) && createTypeFunction == CreateType.OBJECT) {
                        return true;
                    }
                }
                if (createTypeFunction == CreateType.COMPONENT) {
                    List<RfHid> createHids = CheckOVM51b.this.createComponentHidsByEnclosingFunction.get(enclosingFunction);
                    if (createHids == null) {
                        createHids = new ArrayList<RfHid>();
                    }
                    createHids.add(hid);
                    CheckOVM51b.this.createComponentHidsByEnclosingFunction.put(enclosingFunction, createHids);
                } else {
                    List<RfHid> createHids = CheckOVM51b.this.createObjectHidsByEnclosingFunction.get(enclosingFunction);
                    if (createHids == null) {
                        createHids = new ArrayList<RfHid>();
                    }
                    createHids.add(hid);
                    CheckOVM51b.this.createObjectHidsByEnclosingFunction.put(enclosingFunction, createHids);
                }
            }
            return true;
        }
    }
}

