/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="3.1")
@CheckID(value="XVM52")
@CheckName(value="XVM52")
@CheckLabel(labels={RuleLabel.FACTORY_CREATE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Allocate with create()")
@CheckDescription(value="All xvm_objects are allocated with create().\n\nImplementation details:\nUse \"type\"::type_id::create() to create an xvm_object when assigning it to a field. Using the class constructor will result in a failure.\n$cast(type, create_component(...)...) will also be considered a failure.\n\nCheck supports pre-waiving.")
public class CheckOVM52
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of base classes full names to be skipped while looking for xvm_object allocations.", name="skipBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipBaseClassesValue;
    private final HidOperatorVisitor assignmentsVisitor = new HidOperatorVisitor(null){

        public boolean visit(HidOperator hidOperator) {
            ISDataAbstract resolvedType;
            RfClass enclosingClass;
            if (!hidOperator.hasOccurrence(HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS) && !hidOperator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                return true;
            }
            if (this.scope == null) {
                return true;
            }
            if (CheckOVM52.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            CheckOVM52.this.notifyCheckAlive();
            if (CheckOVM52.this.pSkipBaseClassesValue != null && !CheckOVM52.this.pSkipBaseClassesValue.isEmpty() && (enclosingClass = (RfClass)this.scope.getEnclosingScope(RfClass.class)) != null) {
                for (String baseClass : CheckOVM52.this.pSkipBaseClassesValue) {
                    if (!CheckOVM52.this.isSubClass(enclosingClass, baseClass)) continue;
                    return true;
                }
            }
            if ((resolvedType = hidOperator.getOperatorResolvedType()) == null || resolvedType instanceof DummyDataType) {
                return true;
            }
            IRfNamedElement dataType = SDataUtils.getDataType((ISDataAbstract)resolvedType).getType();
            if (dataType instanceof RfListType && ((RfListType)dataType).isDynamicArray()) {
                return true;
            }
            IHidObject lhHidObject = hidOperator.getLHValue();
            if (!(lhHidObject instanceof RfHid || lhHidObject instanceof RfHidAccess || lhHidObject instanceof RfHidImplicit)) {
                return true;
            }
            IRfNamedElement element = null;
            if (lhHidObject instanceof RfHidImplicit) {
                String name = ((RfHidImplicit)lhHidObject).getName();
                element = ((RfNamedElement)this.scope).getLocalMember(RfField.class, name, false);
            } else {
                if (lhHidObject instanceof RfHidAccess && ((RfHidAccess)lhHidObject).isSelect()) {
                    lhHidObject = ((RfHidAccess)lhHidObject).getParentHid();
                }
                element = ((RfHid)lhHidObject).getElement();
            }
            if (!(element instanceof RfField)) {
                return true;
            }
            if (!CheckOVM52.this.isOVMObject((RfField)element)) {
                return true;
            }
            ListContainer rhValues = hidOperator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            if (!(rhValue instanceof RfHidAccess || rhValue instanceof RfHid || rhValue instanceof RfHidOperator)) {
                return true;
            }
            IRfNamedElement rhElement = null;
            if (rhValue instanceof RfHidAccess) {
                Hid parentHid = ((RfHidAccess)rhValue).getParentHid();
                if (!parentHid.isMethodCall(false)) {
                    return true;
                }
                rhElement = parentHid.getElement();
            } else if (rhValue instanceof RfHid) {
                if (!((RfHid)rhValue).isMethodCall(false)) {
                    return true;
                }
                rhElement = ((RfHid)rhValue).getElement();
            } else if (((RfHidOperator)rhValue).isNew()) {
                CheckOVM52.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), "'" + element.getName() + "' is allocated using new() instead of create()");
                return true;
            }
            if (!(rhElement instanceof RfFunction) || !((RfFunction)rhElement).isConstructor()) {
                return true;
            }
            CheckOVM52.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), "'" + element.getName() + "' is allocated using new() instead of create()");
            return true;
        }
    };
    private final RfHidVisitor castVisitor = new RfHidVisitor(){

        public boolean visit(RfHid hid) {
            RfClass enclosingClass;
            if (!hid.isMethodCall(false)) {
                return true;
            }
            if (!hid.getName().equals("$cast")) {
                return true;
            }
            if (!(this.holder instanceof HidHolder)) {
                return true;
            }
            if (CheckOVM52.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            IRfNamedElement scope = ((HidHolder)this.holder).getScope();
            if (!(scope instanceof RfNamedElement) || CheckOVM52.this.fOVMProject.isOVMElement((RfNamedElement)scope)) {
                return true;
            }
            CheckOVM52.this.notifyCheckAlive();
            if (CheckOVM52.this.pSkipBaseClassesValue != null && !CheckOVM52.this.pSkipBaseClassesValue.isEmpty() && (enclosingClass = (RfClass)scope.getEnclosingScope(RfClass.class)) != null) {
                for (String baseClass : CheckOVM52.this.pSkipBaseClassesValue) {
                    if (!CheckOVM52.this.isSubClass(enclosingClass, baseClass)) continue;
                    return true;
                }
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
            for (MethodCall methodCall : methodCalls) {
                Map map = methodCall.argumentValuesMapRaw;
                boolean firstArg = false;
                boolean secondArg = false;
                String castedElement = null;
                for (Map.Entry entry : map.entrySet()) {
                    IRfNamedElement element;
                    IHidObject value = (IHidObject)entry.getValue();
                    if (((IRfFieldElement)entry.getKey()).getName().equals("dest_var")) {
                        if (!(value instanceof RfHid) && !(value instanceof RfHidAccess)) {
                            return true;
                        }
                        Hid lhHidObject = null;
                        if (value instanceof RfHidAccess && ((RfHidAccess)value).isSelect()) {
                            lhHidObject = ((RfHidAccess)value).getParentHid();
                        } else if (value instanceof RfHid) {
                            lhHidObject = (Hid)value;
                        } else {
                            return true;
                        }
                        element = lhHidObject.getElement();
                        if (!(element instanceof RfField)) {
                            return true;
                        }
                        if (!CheckOVM52.this.isOVMObject((RfField)element)) {
                            return true;
                        }
                        firstArg = true;
                        castedElement = element.getName();
                        continue;
                    }
                    if (!((IRfFieldElement)entry.getKey()).getName().equals("source_exp")) continue;
                    if (!(value instanceof RfHidAccess)) {
                        return true;
                    }
                    Hid parentHid = ((RfHidAccess)value).getParentHid();
                    if (!parentHid.isMethodCall(false)) {
                        return true;
                    }
                    element = parentHid.getElement();
                    if (!(element instanceof RfFunction) || !element.getName().startsWith("create_component")) {
                        return true;
                    }
                    secondArg = true;
                }
                if (!firstArg || !secondArg || castedElement == null) continue;
                CheckOVM52.this.addHit(this.parserPath, methodCall.occurrence, "'" + castedElement + "' is allocated using create_component() instead of create()");
            }
            return true;
        }
    };
    private String libObjectClassName;

    public CheckOVM52(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.libObjectClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object");
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.assignmentsVisitor);
        this.fOVMProject.getRfProject().visitHidObject(null, this.castVisitor);
    }

    private boolean isOVMObject(RfNamedElement elem) {
        if (elem == null || !(elem instanceof RfField)) {
            return false;
        }
        RfField field = (RfField)elem;
        RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
        if (fieldType == null || this.fOVMProject.isOVMElement(fieldType)) {
            return false;
        }
        return fieldType.isSubClass(this.libObjectClassName, true);
    }

    public final boolean isSubClass(RfClass clazz, String fullName) {
        if (fullName == null) {
            return false;
        }
        RfClass parent = clazz;
        while (parent != null) {
            if (fullName.equals(parent.getFullName())) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

