/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;

@CheckVersion(value="3.1")
@CheckID(value="XVM53")
@CheckName(value="XVM53")
@CheckLabel(labels={RuleLabel.CONFIG_DB, RuleLabel.BUILD_PHASE, RuleLabel.TEST, RuleLabel.VERIFICATION})
@CheckTitle(value="Illustrate configuration using set_config_*() and/or uvm_config_db#()::set() in case of UVM")
@CheckDescription(value="Inside the build phase of a test class, at least one set_config_*() or  uvm_config_db#()::set() must be used in order to demonstrate the VC configuration capability.\nNote: The linter only checks the build() method of the class, it does not verify the build phase method in super classes.")
public class CheckOVM53
extends OVMComplianceCheck {
    public CheckOVM53(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fTests.isEmpty()) {
            return;
        }
        for (RfClass testClass : this.fOVMProject.fTests.values()) {
            this.notifyCheckAlive();
            List<RfFunction> candidates = testClass.getFunctionsWithPrefix(this.fOVMProject.getBuildPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (candidates == null || candidates.isEmpty()) {
                this.addHit(testClass, "No " + this.fOVMProject.getBuildPhaseMethodName() + "() method in test class '" + testClass.getName() + "'");
                continue;
            }
            List<RfFunctionCall> calls = candidates.get(0).getFunctionCallsWithPrefix("set_config_", 2);
            if (calls != null && !calls.isEmpty()) continue;
            boolean found = false;
            calls = candidates.get(0).getFunctionCallsWithPrefix("uvm_config_db#(", 2);
            if (calls != null && !calls.isEmpty()) {
                for (RfFunctionCall call : calls) {
                    if (!call.getName().endsWith(")::set")) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            this.addHit(testClass, "No set_config_*() or uvm_config_db#(*)::set() calls in the " + this.fOVMProject.getBuildPhaseMethodName() + "() method of test class '" + testClass.getName() + "'");
        }
    }
}

