/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="3.1")
@CheckID(value="XVM55")
@CheckName(value="XVM55")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.FORK, RuleLabel.DRIVER, RuleLabel.MONITOR, RuleLabel.VERIFICATION})
@CheckTitle(value="Mandatory fork join in run phase for drivers and monitors")
@CheckDescription(value="The overridden run phase, declared in a monitor or a driver class, must contain task calls between fork and join/join_none.\n\nCheck supports pre-waiving.")
public class CheckOVM55
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, additional statements are allowed in the run phase and between fork and join/join_none.", name="allowAdditionalStatements", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowAdditionalStatements;
    HashSet<RfActionBlock> forkJoinBlocks = new HashSet();

    public CheckOVM55(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfFunction> functions;
        RfDefElement declaration;
        if (this.fOVMProject.fMonitors.isEmpty() && this.fOVMProject.fDrivers.isEmpty()) {
            return;
        }
        for (RfClass monitor : this.fOVMProject.fMonitors.values()) {
            declaration = monitor.getDeclaration();
            if (declaration == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(declaration.getParserPath(), this)) continue;
            functions = monitor.getFunctionsWithPrefix(this.fOVMProject.getRunPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (functions == null || functions.isEmpty()) {
                functions = monitor.getTasksWithPrefix(this.fOVMProject.getRunPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            if (functions == null || functions.isEmpty()) continue;
            this.checkRunMethod(functions.get(0), monitor);
        }
        for (RfClass driver : this.fOVMProject.fDrivers.values()) {
            declaration = driver.getDeclaration();
            if (declaration == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(declaration.getParserPath(), this)) continue;
            functions = driver.getFunctionsWithPrefix(this.fOVMProject.getRunPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (functions == null || functions.isEmpty()) {
                functions = driver.getTasksWithPrefix(this.fOVMProject.getRunPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            if (functions == null || functions.isEmpty()) continue;
            this.checkRunMethod(functions.get(0), driver);
        }
    }

    private void checkRunMethod(RfFunction method, RfClass classs) {
        this.notifyCheckAlive();
        if (!this.pAllowAdditionalStatements) {
            RfHidOperatorVisitor operatorsVisitor = new RfHidOperatorVisitor();
            method.visitHidObject(this.fOVMProject.getRfProject(), operatorsVisitor);
            if (operatorsVisitor.getStatementOperatorFound()) {
                this.addHit(method, "The " + this.fOVMProject.getRunPhaseMethodName() + "() method should contain only fork-join blocks with task calls inside. This " + this.fOVMProject.getRunPhaseMethodName() + " method contains more statemens.");
                return;
            }
        }
        List<RfActionBlock> blocks = method.getLocalMembers(RfActionBlock.class);
        this.checkActionBlocks(blocks);
        if (this.forkJoinBlocks.isEmpty()) {
            this.addHit(method, "No fork - join blocks in the " + this.fOVMProject.getRunPhaseMethodName() + "() method of '" + classs.getName() + "'");
            return;
        }
        this.checkTaskCalls(method, classs);
        this.forkJoinBlocks.clear();
    }

    private void checkActionBlocks(Collection<RfActionBlock> blocks) {
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        for (RfActionBlock block : blocks) {
            List<RfActionBlock> localBlocks;
            if (block.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN_NONE.value() | IRfActionBlockElement.BlockQualifier.FORK_JOIN.value())) {
                this.forkJoinBlocks.add(block);
            }
            if ((localBlocks = block.getLocalMembers(RfActionBlock.class)) == null || localBlocks.isEmpty()) continue;
            this.checkActionBlocks(localBlocks);
        }
    }

    public void checkTaskCalls(RfFunction method, RfClass classs) {
        boolean taskCallFound = false;
        for (RfActionBlock block : this.forkJoinBlocks) {
            MethodCallsVisitor methodCallsVisitor = new MethodCallsVisitor(classs);
            block.visitHidObject(this.fOVMProject.getRfProject(), methodCallsVisitor);
            if (taskCallFound) continue;
            taskCallFound = methodCallsVisitor.getTaskCallFound();
        }
        if (!taskCallFound) {
            this.addHit(method, "No task calls in the " + this.fOVMProject.getRunPhaseMethodName() + "() method of '" + classs.getName() + "'");
        }
    }

    private class MethodCallsVisitor
    extends RfHidVisitor {
        RfClass classs;
        boolean taskCallFound;

        public MethodCallsVisitor(RfClass classs) {
            this.classs = classs;
            this.taskCallFound = false;
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (!hidObject.hasQualifier(HidQualifierCache.STATEMENT_QUALIFIER)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            if (function.isTask()) {
                this.taskCallFound = true;
            } else {
                CheckOVM55.this.addHit(this.parserPath, hidObject, "Not all method calls are tasks in the " + CheckOVM55.this.fOVMProject.getRunPhaseMethodName() + "() method of '" + this.classs.getName() + "'");
            }
            return true;
        }

        public boolean getTaskCallFound() {
            return this.taskCallFound;
        }
    }

    private class RfHidOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private boolean statementOperatorFound = false;

        public boolean visit(RfHidOperator hidOperator) {
            if (hidOperator.isWhileCondition() || hidOperator.isIfCondition() || hidOperator.isRepeatCondition() || hidOperator.isCaseCondition() || hidOperator.isCaseItemCondition() || hidOperator.isForCondition() || hidOperator.isForStep() || hidOperator.isDisableStatement() || hidOperator.isWaitStatement() || hidOperator.isReturnStatement() || hidOperator.isBreakStatement() || hidOperator.isContinueStatement() || hidOperator.isLiteralElse() || hidOperator.hasOccurrence(HidOperatorQualifier.IS_ARGUMENT_VALUE)) {
                return true;
            }
            this.statementOperatorFound = true;
            return false;
        }

        public boolean getStatementOperatorFound() {
            return this.statementOperatorFound;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

