/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;

@CheckVersion(value="3.1")
@CheckID(value="XVM58")
@CheckName(value="XVM58")
@CheckLabel(labels={RuleLabel.BUILD_PHASE, RuleLabel.SUPER, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Mandatory super.build phase call")
@CheckDescription(value="The build phase method must call super.build phase.\n\nCheck supports pre-waiving.")
public class CheckOVM58
extends OVMComplianceCheck {
    public CheckOVM58(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass elem : this.fOVMProject.getAllComponents().values()) {
            if (this.checkPreWaivers(elem.getFile())) continue;
            List<RfFunction> candidates = elem.getFunctionsWithPrefix(this.fOVMProject.getBuildPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (candidates == null || candidates.isEmpty()) {
                candidates = elem.getTasksWithPrefix(this.fOVMProject.getBuildPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            if (candidates == null || candidates.isEmpty()) continue;
            this.notifyCheckAlive();
            for (RfFunction candidate : candidates) {
                List<RfFunctionCall> fctCalls = candidate.getFunctionCallsWithPrefix("super." + this.fOVMProject.getBuildPhaseMethodName(), 1);
                if (fctCalls == null || fctCalls.isEmpty()) {
                    this.addHit(candidate, String.valueOf(this.fOVMProject.getBuildPhaseMethodName()) + "() method of '" + elem.getName() + "' does not call super." + this.fOVMProject.getBuildPhaseMethodName());
                    continue;
                }
                this.addPassedHit(fctCalls.get(0), String.valueOf(this.fOVMProject.getBuildPhaseMethodName()) + "() method of '" + elem.getName() + "' calls super." + this.fOVMProject.getBuildPhaseMethodName());
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

