/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="3.1")
@CheckID(value="XVM59")
@CheckName(value="XVM59")
@CheckLabel(labels={RuleLabel.CONNECT_PHASE, RuleLabel.METHOD, RuleLabel.TLM_PORT, RuleLabel.VERIFICATION})
@CheckTitle(value="TLM Connects")
@CheckDescription(value="TLM connects must occur in the connect phase.\n\nCheck supports pre-waiving.")
public class CheckOVM59
extends OVMComplianceCheck {
    public CheckOVM59(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        final RfProject rfProject = this.fOVMProject.getRfProject();
        final String libComponentName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component");
        final String libPortBaseName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_port_base");
        RfHidVisitor hidVisitor = new RfHidVisitor(){
            private ParserPath parserPath;

            @Override
            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public boolean visit(RfHid hid) {
                if (hid != null) {
                    IRfNamedElement holderScope;
                    RfClass hidClass;
                    RfNamedElement hidEnclosingScope;
                    CheckOVM59.this.notifyCheckAlive();
                    if (CheckOVM59.this.checkPreWaivers(this.parserPath)) {
                        return true;
                    }
                    IRfNamedElement hidNamedElement = hid.getElement();
                    if (hidNamedElement instanceof RfFunction && "connect".equals(hid.getName()) && (hidEnclosingScope = ((RfFunction)hidNamedElement).getEnclosingScope()) instanceof RfClass && (hidClass = (RfClass)hidEnclosingScope).isSubClass(libPortBaseName, true) && this.holder instanceof RfHidHolder && (holderScope = ((RfHidHolder)this.holder).getScope()) instanceof RfNamedElement && !CheckOVM59.this.fOVMProject.isOVMElement((RfNamedElement)holderScope)) {
                        RfFunction holderFunctionScope = ((RfNamedElement)holderScope).getEnclosingScope(RfFunction.class);
                        if (holderFunctionScope != null) {
                            RfClass holderClassScope = holderFunctionScope.getEnclosingScope(RfClass.class);
                            if (holderClassScope.isSubClass(libComponentName, false)) {
                                String connectPhaseFunctionName = CheckOVM59.this.fOVMProject.getConnectPhaseMethodName();
                                if (connectPhaseFunctionName.equals(holderFunctionScope.getName())) {
                                    CheckOVM59.this.addPassedHit(this.parserPath, hid, "TLM connection found in " + connectPhaseFunctionName + "().");
                                } else {
                                    RfFunction connectPhaseFunction = holderClassScope.getFunctionWithPrefix(connectPhaseFunctionName, 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                                    if (connectPhaseFunction == null) {
                                        CheckOVM59.this.addHit(this.parserPath, hid, "TLM connection found outside a " + connectPhaseFunctionName + "()! " + connectPhaseFunctionName + "() function not found!");
                                    } else {
                                        boolean indirectlyCalled = LintUtils.findFunctionCall(rfProject, connectPhaseFunction, holderFunctionScope);
                                        if (indirectlyCalled) {
                                            CheckOVM59.this.addPassedHit(this.parserPath, hid, "TLM connection indirectly called from " + connectPhaseFunctionName + "().");
                                        } else {
                                            CheckOVM59.this.addHit(this.parserPath, hid, "TLM connection found outside " + connectPhaseFunctionName + "()!");
                                        }
                                    }
                                }
                            } else {
                                CheckOVM59.this.addHit(this.parserPath, hid, "TLM connection found outside a '" + libComponentName + "' based class!");
                            }
                        } else {
                            CheckOVM59.this.addHit(this.parserPath, hid, "TLM connection found outside a function!");
                        }
                    }
                }
                return true;
            }
        };
        rfProject.visitHidObject(rfProject, hidVisitor);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

