/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="3.1")
@CheckID(value="XVM6")
@CheckName(value="XVM6")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Sequence.body()")
@CheckDescription(value="Verify the existence of the body() method in the code of a sequence.\n\nException: Virtual sequences are not checked.")
public class CheckOVM6
extends OVMComplianceCheck {
    public CheckOVM6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass sequence : this.fOVMProject.fSequences.values()) {
            if (sequence.hasVirtualQualifier() || this.fOVMProject.isOVMElement(sequence)) continue;
            this.notifyCheckAlive();
            List<RfFunction> candidates = sequence.getFunctionsWithPrefix("body", 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (candidates == null || candidates.isEmpty()) {
                candidates = sequence.getTasksWithPrefix("body", 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            if (candidates == null || candidates.isEmpty() || this.fOVMProject.isOVMElement(candidates.get(0).getEnclosingScope())) {
                this.addHit(sequence, "body() method not found");
                continue;
            }
            this.addPassedHit(candidates.get(0), "body() method found");
        }
    }
}

