/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractNamePatternParametersCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="3.1")
@CheckID(value="XVM60")
@CheckName(value="XVM60")
@CheckLabel(labels={RuleLabel.FACTORY_CREATE, RuleLabel.COMPONENT, RuleLabel.BUILD_PHASE, RuleLabel.VERIFICATION})
@CheckTitle(value="Component Creation")
@CheckDescription(value="Component creation - check that all components should be created using the XVM 2.0 creation style. A warning should be generated if old style is used. Related checks: ARAD, ARAI, ARMI, ARDI, ARSI, ARAS, XVM28, XVM46, XVM49, XVM51.\n\nNote: Components should be created using class_name::type_id::create() method inside the build() function. Please see the example in rule XVM51.\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="testbenchClassNamePattern", isVisible=true)
public class CheckOVM60
extends AbstractNamePatternParametersCheck {
    private static final String $CAST = "$cast";
    private static final String CREATE_COMPONENT = "create_component";
    private static final String SOURCE_EXP = "source_exp";
    private static final String DEST_VAR = "dest_var";

    public CheckOVM60(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fTests.isEmpty() && this.fOVMProject.fEnvs.isEmpty() && this.fOVMProject.fAgents.isEmpty() && this.fOVMProject.fMonitors.isEmpty() && this.fOVMProject.fDrivers.isEmpty() && this.fOVMProject.fSequencers.isEmpty() && this.getClassesWithPatterns("testbenchClassNamePattern").isEmpty() && this.fOVMProject.fScoreboards.isEmpty()) {
            return;
        }
        this.checkComponentCreation(this.fOVMProject.fTests, this.getClassesWithPatterns("testbenchClassNamePattern"));
        this.checkComponentCreation(this.getClassesWithPatterns("testbenchClassNamePattern"), this.fOVMProject.fEnvs);
        this.checkComponentCreation(this.fOVMProject.fEnvs, this.fOVMProject.fAgents);
        this.checkComponentCreation(this.fOVMProject.fAgents, this.fOVMProject.fAgents);
        this.checkComponentCreation(this.fOVMProject.fEnvs, this.fOVMProject.fMonitors);
        this.checkComponentCreation(this.fOVMProject.fAgents, this.fOVMProject.fMonitors);
        this.checkComponentCreation(this.fOVMProject.fAgents, this.fOVMProject.fSequencers);
        this.checkComponentCreation(this.fOVMProject.fAgents, this.fOVMProject.fDrivers);
        this.checkComponentCreation(this.getClassesWithPatterns("testbenchClassNamePattern"), this.fOVMProject.fScoreboards);
    }

    private void checkComponentCreation(Map<String, RfClass> containers, Map<String, RfClass> elements) {
        if (containers == null || elements == null || elements.isEmpty()) {
            return;
        }
        for (RfClass container : containers.values()) {
            List<RfFunction> allFunctions;
            this.notifyCheckAlive();
            if (container.getFile() == null || this.checkPreWaivers(container.getFile().getParserPath()) || (allFunctions = container.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) == null || allFunctions.isEmpty()) continue;
            for (RfFunction aFunction : allFunctions) {
                this.checkOldStyleCreates(aFunction, elements);
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private void checkOldStyleCreates(RfFunction aFunction, final Map<String, RfClass> elements) {
        RfHidVisitor castVisitor = new RfHidVisitor(){

            public boolean visit(RfHid hid) {
                if (hid == null || !hid.isMethodCall(false)) {
                    return true;
                }
                if (!hid.getName().equals(CheckOVM60.$CAST)) {
                    return true;
                }
                if (!(this.holder instanceof HidHolder)) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                for (MethodCall methodCall : methodCalls) {
                    boolean firstArg = false;
                    boolean secondArg = false;
                    String castedElement = null;
                    for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                        IRfNamedElement element;
                        IHidObject value = (IHidObject)entry.getValue();
                        if (((IRfFieldElement)entry.getKey()).getName().equals(CheckOVM60.DEST_VAR)) {
                            if (!(value instanceof RfHid) && !(value instanceof RfHidAccess)) {
                                return true;
                            }
                            Hid lhHidObject = null;
                            if (value instanceof RfHidAccess && ((RfHidAccess)value).isSelect()) {
                                lhHidObject = ((RfHidAccess)value).getParentHid();
                            } else if (value instanceof RfHid) {
                                lhHidObject = (Hid)value;
                            } else {
                                return true;
                            }
                            element = lhHidObject.getElement();
                            if (!(element instanceof RfField)) {
                                return true;
                            }
                            RfField field = (RfField)element;
                            if (!this.isValidField(field, elements)) {
                                return true;
                            }
                            firstArg = true;
                            castedElement = element.getName();
                            continue;
                        }
                        if (!((IRfFieldElement)entry.getKey()).getName().equals(CheckOVM60.SOURCE_EXP)) continue;
                        if (!(value instanceof RfHidAccess)) {
                            return true;
                        }
                        Hid parentHid = ((RfHidAccess)value).getParentHid();
                        if (!parentHid.isMethodCall(false)) {
                            return true;
                        }
                        element = parentHid.getElement();
                        if (!(element instanceof RfFunction) || !element.getName().startsWith(CheckOVM60.CREATE_COMPONENT)) {
                            return true;
                        }
                        secondArg = true;
                    }
                    if (!firstArg || !secondArg || castedElement == null) continue;
                    CheckOVM60.this.addHit(this.parserPath, methodCall.occurrence, "'" + castedElement + "' is created using old creation style!");
                }
                return true;
            }

            private boolean isValidField(RfField field, Map<String, RfClass> elements2) {
                if (field == null) {
                    return false;
                }
                RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
                if (fieldType == null || !elements2.containsKey(fieldType.getFullName())) {
                    return false;
                }
                String libObjectClassName = OVMUtils.prependLibraryPrefixTo(CheckOVM60.this.fOVMProject.getLibraryKind(), "_object");
                return fieldType.isSubClass(libObjectClassName, true);
            }
        };
        aFunction.visitHidObject(this.fOVMProject.getRfProject(), castVisitor);
    }
}

