/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.standard.checks.AbstractTestDirectiveOrFunctionCall;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="17.1.4")
@CheckID(value="XVM61")
@CheckName(value="XVM61")
@CheckLabel(labels={RuleLabel.BUILD_PHASE, RuleLabel.UVM_DIRECTIVE, RuleLabel.VERIFICATION})
@CheckTitle(value="Timeout must be set before run phase")
@CheckDescription(value="Timeout must be set either by using +UVM_TIMEOUT directive in the simulation arguments or by using uvm_top.set_timeout()\nin every test before run phase (in constructor or during build, connect, end_of_elaboration or start_of_simulation phases).\n\nCheck supports pre-waiving.")
public class CheckOVM61
extends AbstractTestDirectiveOrFunctionCall {
    public CheckOVM61(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    protected boolean isValidFunction(RfFunction function) {
        RfClass enclosingClass;
        return function.getName().equals("set_timeout") && (enclosingClass = function.getEnclosingScope(RfClass.class)) != null && enclosingClass.isSubClass("uvm_root", true);
    }

    @Override
    protected String getFailMessage(RfClass test) {
        return "Timeout must be set using +UVM_TIMEOUT or using 'uvm_top.set_timeout()' before start_of_simulation phase in test '" + LintUtils.getNamedElementFullName(test) + "'!";
    }

    @Override
    protected String getDirectiveValueFailMessage() {
        return "Timeout set using +UVM_TIMEOUT must be greater than 0, otherwise the timeout is disabled!";
    }

    @Override
    protected String getArgumentValueFailMessage(String functionCall) {
        return "Timeout set using '" + functionCall + "()' must be greater than 0, otherwise the timeout is disabled!";
    }

    @Override
    protected String getDirectiveValue() {
        return BuildConfigManager.getUvmTimeout((IProject)this.getIProject());
    }
}

