/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.standard.checks.AbstractTestDirectiveOrFunctionCall;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="17.1.4")
@CheckID(value="XVM62")
@CheckName(value="XVM62")
@CheckLabel(labels={RuleLabel.BUILD_PHASE, RuleLabel.UVM_DIRECTIVE, RuleLabel.VERIFICATION})
@CheckTitle(value="Error limit must be set before run phase")
@CheckDescription(value="Error limit must be set either by using +UVM_MAX_QUIT_COUNT directive in the simulation arguments or by using uvm_report_server.set_max_quit_count() or\nuvm_report_object.set_report_max_quit_count() in every test before run phase (in constructor or during build, connect, end_of_elaboration or start_of_simulation phases).\n\nCheck supports pre-waiving.")
public class CheckOVM62
extends AbstractTestDirectiveOrFunctionCall {
    public CheckOVM62(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    protected boolean isValidFunction(RfFunction function) {
        RfClass enclosingClass;
        if (function.getName().equals("set_max_quit_count") && (enclosingClass = function.getEnclosingScope(RfClass.class)) != null && enclosingClass.isSubClass("uvm_report_server", true)) {
            return true;
        }
        return function.getName().equals("set_report_max_quit_count") && (enclosingClass = function.getEnclosingScope(RfClass.class)) != null && enclosingClass.isSubClass("uvm_report_object", true);
    }

    @Override
    protected String getDirectiveValueFailMessage() {
        return "Error limit set using +UVM_MAX_QUIT_COUNT must be greater than 0, otherwise the error limit is disabled!";
    }

    @Override
    protected String getDirectiveValue() {
        return BuildConfigManager.getUvmMaxQuitCount((IProject)this.getIProject());
    }

    @Override
    protected String getFailMessage(RfClass test) {
        return "Error limit must be set using +UVM_MAX_QUIT_COUNT or using 'uvm_report_server.set_max_quit_count()' before start_of_simulation phase in test '" + LintUtils.getNamedElementFullName(test) + "'!";
    }

    @Override
    protected String getArgumentValueFailMessage(String functionCall) {
        return "Error limit set using '" + functionCall + "()' must be greater than 0, otherwise the error limit is disabled!";
    }
}

