/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="17.1.21")
@CheckID(value="XVM63")
@CheckName(value="XVM63")
@CheckLabel(labels={RuleLabel.FUNCTIONAL, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use compare_field_int() to compare more than 64 bits")
@CheckDescription(value="xvm_comparer.compare_field_int() can't compare more than 64 bits and does not report an error or warning when comparing more than 64 bits.\n\nCheck supports pre-waiving.")
public class CheckOVM63
extends OVMComplianceCheck {
    private static final String METHOD_NAME = "compare_field_int";
    private static final String HIT_MESSAGE_FORMAT = "''compare_field_int()'' is used to compare {0} bits which is more than 64 bits!";
    private Map<RfNamedElement, Set<RfHidMethodCallPair>> hids = new HashMap<RfNamedElement, Set<RfHidMethodCallPair>>();
    private RfClass comparerClass;
    private Map<MethodCall, List<Integer>> lastValues = new HashMap<MethodCall, List<Integer>>();
    private final HidOperatorVisitor assignmentsVisitor = new HidOperatorVisitor(null){

        public boolean visit(HidOperator hidObject) {
            if (!hidObject.hasOccurrence(HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS)) {
                return true;
            }
            if (CheckOVM63.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (this.scope == null || !CheckOVM63.this.hids.containsKey(this.scope)) {
                return true;
            }
            HidOperator hidOperator = hidObject;
            IHidObject lhHidObject = hidOperator.getLHValue();
            if (!(lhHidObject instanceof RfHid)) {
                return true;
            }
            ListContainer rhValues = hidOperator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            IHidObject rhValue = (IHidObject)rhValues.get(0);
            if (!(rhValue instanceof IHidImplicit)) {
                return true;
            }
            MethodCall methodCall = null;
            Set<RfHidMethodCallPair> pairs = CheckOVM63.this.hids.get(this.scope);
            for (RfHidMethodCallPair hidMethodCall : pairs) {
                if (!hidMethodCall.hid.equals(lhHidObject) || hidMethodCall.methodCall.occurrence.getOffset() <= hidOperator.getOccurrence().getOffset()) continue;
                methodCall = hidMethodCall.methodCall;
                Number number = ((IHidImplicit)rhValue).parseNumberValue();
                if (number == null) continue;
                if (CheckOVM63.this.lastValues.get(methodCall) == null) {
                    CheckOVM63.this.lastValues.put(methodCall, Arrays.asList(hidOperator.getOccurrence().getOffset(), number.intValue()));
                    continue;
                }
                if (CheckOVM63.this.lastValues.get(methodCall).get(0) >= hidOperator.getOccurrence().getOffset()) continue;
                CheckOVM63.this.lastValues.put(methodCall, Arrays.asList(hidOperator.getOccurrence().getOffset(), number.intValue()));
            }
            return true;
        }
    };
    private static final EnumSet<HidFlatteningOption> METHOD_CALL_HID_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_SELECTS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALLS, HidFlatteningOption.IGNORE_CONCAT_AND_ASSIGN_PATTERNS);

    public CheckOVM63(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        this.initializeClassNames();
        if (this.comparerClass == null) {
            return;
        }
        this.hids = new HashMap<RfNamedElement, Set<RfHidMethodCallPair>>();
        this.lastValues = new HashMap<MethodCall, List<Integer>>();
        LocalHidVisitor visitor = new LocalHidVisitor();
        RfProject rfProject = this.fOVMProject.getRfProject();
        rfProject.visitHidObject(rfProject, visitor);
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.assignmentsVisitor);
        for (Map.Entry<RfNamedElement, Set<RfHidMethodCallPair>> entry : this.hids.entrySet()) {
            RfNamedElement scope = entry.getKey();
            for (RfHidMethodCallPair pair : entry.getValue()) {
                List<Integer> values = this.lastValues.get(pair.methodCall);
                if (values != null && values.size() == 2 && values.get(1) <= 64 || values == null || values.size() != 2) continue;
                this.addHit(scope.getFile().getParserPath(), pair.methodCall.occurrence, MessageFormat.format(HIT_MESSAGE_FORMAT, values.get(1)));
            }
        }
    }

    private void initializeClassNames() {
        String comparerClassName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_comparer");
        String comparerClassFullName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + comparerClassName;
        this.comparerClass = this.fOVMProject.getRfProject().getClass(comparerClassFullName, true);
    }

    private boolean isCompareFieldIntMethod(RfFunction function) {
        if (function == null) {
            return false;
        }
        if (!function.getName().equals(METHOD_NAME)) {
            return false;
        }
        if (function.getFullName().equals(String.valueOf(this.comparerClass.getFullName()) + "." + METHOD_NAME)) {
            return true;
        }
        RfClass enclosingClass = function.getEnclosingScope(RfClass.class);
        if (enclosingClass == null) {
            return false;
        }
        return enclosingClass.isSubClass(this.comparerClass);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class LocalHidVisitor
    extends RfHidVisitor {
        private LocalHidVisitor() {
        }

        public boolean visit(RfHid hid) {
            if (hid == null) {
                return true;
            }
            if (CheckOVM63.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            if (hidNamedElement.isPredefined()) {
                return true;
            }
            if (!(this.holder instanceof HidHolder)) {
                return true;
            }
            IRfNamedElement holderScope = ((HidHolder)this.holder).getScope();
            if (holderScope == null) {
                return true;
            }
            if (!(holderScope instanceof RfNamedElement)) {
                return true;
            }
            if (CheckOVM63.this.fOVMProject.isOVMElement((RfNamedElement)holderScope)) {
                return true;
            }
            CheckOVM63.this.notifyCheckAlive();
            if (CheckOVM63.this.isCompareFieldIntMethod((RfFunction)hidNamedElement)) {
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                block0: for (MethodCall methodCall : methodCalls) {
                    if (methodCall.argumentValuesMap == null) continue;
                    for (Map.Entry argumentEntry : methodCall.argumentValuesMapRaw.entrySet()) {
                        IRfNamedElement argumentKey = (IRfNamedElement)argumentEntry.getKey();
                        if (argumentKey == null || !argumentKey.getName().equals("size")) continue;
                        IHidObject value = (IHidObject)argumentEntry.getValue();
                        if (value instanceof HidOperator && ((HidOperator)value).isMinus()) continue block0;
                        Set values = HidUtils.flattenToHids((IHidObject)value, METHOD_CALL_HID_FLATTENING);
                        for (IHid ihid : values) {
                            Number number;
                            if (ihid instanceof IHidImplicit && (number = ((IHidImplicit)ihid).parseNumberValue()) != null && number.intValue() > 64) {
                                CheckOVM63.this.addHit(this.parserPath, methodCall.occurrence, MessageFormat.format(CheckOVM63.HIT_MESSAGE_FORMAT, number.intValue()));
                            }
                            if (!(ihid instanceof RfHid)) continue;
                            Set<RfHidMethodCallPair> hidsInScope = CheckOVM63.this.hids.get(holderScope);
                            if (hidsInScope == null) {
                                hidsInScope = new HashSet<RfHidMethodCallPair>();
                            }
                            hidsInScope.add(new RfHidMethodCallPair((RfHid)ihid, methodCall));
                            CheckOVM63.this.hids.put((RfNamedElement)holderScope, hidsInScope);
                        }
                    }
                }
            }
            return true;
        }
    }

    private static class RfHidMethodCallPair {
        public RfHid hid;
        public MethodCall methodCall;

        public RfHidMethodCallPair(RfHid hid, MethodCall methodCall) {
            this.hid = hid;
            this.methodCall = methodCall;
        }
    }
}

