/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractConstructorCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="17.1.24")
@CheckID(value="XVM64")
@CheckName(value="XVM64")
@CheckLabel(labels={RuleLabel.OBJECT, RuleLabel.CONSTRUCTOR, RuleLabel.VERIFICATION})
@CheckTitle(value="Object constructor")
@CheckDescription(value="The constructor for an xvm_object must look as follows (except for xvm_object derivatives that are also a xvm_component): \n\nfunction new(string name);\n  super.new(name);\nendfunction\n\nThe constructor cannot pass additional arguments. \nThe constructor cannot contain additional lines or member initialization.\n\nCheck supports pre-waiving.")
public class CheckOVM64
extends AbstractConstructorCheck {
    private static final Set<String> EXCLUDED_UVM_CLASSES = new HashSet<String>(Arrays.asList("uvm_barrier", "uvm_heartbeat_callback", "uvm_class_pair", "uvm_heartbeat", "uvm_mem", "uvm_phase", "uvm_reg", "uvm_reg_fifo", "uvm_reg_indirect_data", "uvm_reg_block", "uvm_resource_base", "uvm_resource", "uvm_bit_rsrc", "uvm_byte_rsrc", "uvm_int_rsrc", "uvm_obj_rsrc", "uvm_string_rsrc", "uvm_sequence_library_cfg", "uvm_transaction", "uvm_reg_indirect_ftdr_seq", "uvm_vreg"));
    private static final Set<String> EXCLUDED_OVM_CLASSES = new HashSet<String>(Arrays.asList("ovm_barrier", "ovm_port_base", "ovm_transaction", "ovm_built_in_pair", "avm_built_in_pair", "ovm_class_pair", "avm_class_pair", "ovm_sequence_item", "ovm_sequence_base", "ovm_sequence", "ovm_urm_override_request"));

    public CheckOVM64(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        HashMap<String, RfClass> classes = new HashMap<String, RfClass>();
        for (RfClass clazz : this.fOVMProject.getAllObjects().values()) {
            RfClass xvmParent = this.getFirstXVMParent(clazz);
            if (xvmParent != null && (this.fOVMProject.getLibraryKind() == 2 && EXCLUDED_UVM_CLASSES.contains(xvmParent.getName()) || this.fOVMProject.getLibraryKind() == 1 && (EXCLUDED_OVM_CLASSES.contains(xvmParent.getName()) || clazz.isSubClass("ovm_port_base", true)))) continue;
            classes.put(clazz.getFullName(), clazz);
        }
        if (classes.isEmpty()) {
            return;
        }
        this.checkConstructor(classes, false, true);
    }
}

