/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="17.1.26")
@CheckID(value="XVM65")
@CheckName(value="XVM65")
@CheckLabel(labels={RuleLabel.TEST, RuleLabel.METHOD, RuleLabel.ARGUMENT, RuleLabel.VERIFICATION})
@CheckTitle(value="run_test() must be called without arguments")
@CheckDescription(value="run_test() must be called without any arguments.\n\nCheck supports pre-waiving.")
public class CheckOVM65
extends OVMComplianceCheck {
    public CheckOVM65(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String xvmPkg = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg");
        String xvmRoot = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_root");
        final String topRunTest = String.valueOf(xvmPkg) + "::" + xvmRoot + ".run_test";
        final String globalRunTest = String.valueOf(xvmPkg) + "::run_test";
        RfHidVisitor visitor = new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                RfHid hid = hidObject;
                if (!hid.isMethodCall(false)) {
                    return true;
                }
                if (CheckOVM65.this.pathIsPrewaived(this.parserPath)) {
                    return true;
                }
                if (!"run_test".equals(hid.getName())) {
                    return true;
                }
                IRfNamedElement element = hid.getElement();
                if (element == null) {
                    return true;
                }
                CheckOVM65.this.notifyCheckAlive();
                String elementName = ((RfNamedElement)element).getFullName();
                if (!globalRunTest.equals(elementName) && !topRunTest.equals(elementName)) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                for (MethodCall methodCall : methodCalls) {
                    if (methodCall.argumentValuesMap == null || methodCall.argumentValuesMap.isEmpty()) continue;
                    CheckOVM65.this.addHit(this.parserPath, methodCall.occurrence, "Task 'run_test()' should be called without arguments!");
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
    }

    protected boolean pathIsPrewaived(ParserPath path) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }
}

