/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfSuperImplicitVariable;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="17.1.26")
@CheckID(value="XVM66")
@CheckName(value="XVM66")
@CheckLabel(labels={RuleLabel.OBJECT, RuleLabel.METHOD, RuleLabel.CLASS, RuleLabel.OVERRIDE, RuleLabel.VERIFICATION})
@CheckTitle(value="All classes that inherit from xvm_object must implement do_compare()")
@CheckDescription(value="The do_compare() method must be implemented in all classes that inherit from xvm_object because the default implementation always returns 1.\n\nCheck supports pre-waiving.")
public class CheckOVM66
extends OVMComplianceCheck {
    private static final String DO_COMPARE = "do_compare";
    @CheckParameter(defaultValue="false", description="When true, only classes on which do_compare() is called will be checked.", name="skipNonComparedClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipNonComparedClassesValue;
    private Set<RfClass> illegalClasses;
    private Set<RfClass> legalClasses;

    public CheckOVM66(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        this.legalClasses = new HashSet<RfClass>();
        this.illegalClasses = new HashSet<RfClass>();
        block0: for (RfNamedElement element : this.fOVMProject.getAllNonXVMClasses()) {
            RfClass clazz;
            if (element == null || !(element instanceof RfClass) || this.checkPreWaivers((clazz = (RfClass)element).getFile())) continue;
            List<RfFunction> functions = clazz.getFunctionsWithPrefix(DO_COMPARE, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            this.filterFunctions(functions);
            if (functions != null && !functions.isEmpty()) {
                this.legalClasses.add(clazz);
                continue;
            }
            this.notifyCheckAlive();
            boolean isXVMSubClass = false;
            RfClass parent = clazz;
            while (parent != null) {
                if (parent.getName().equals(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object"))) {
                    isXVMSubClass = true;
                    break;
                }
                List<RfFunction> compareFunctions = parent.getFunctionsWithPrefix(DO_COMPARE, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                this.filterFunctions(compareFunctions);
                if (compareFunctions != null && !compareFunctions.isEmpty()) {
                    this.legalClasses.add(parent);
                    continue block0;
                }
                if (parent.getParent() != null && this.legalClasses.contains(parent.getParent())) {
                    this.legalClasses.add(parent);
                    continue block0;
                }
                if (parent.getParent() != null && this.illegalClasses.contains(parent.getParent())) {
                    this.illegalClasses.add(parent);
                    continue block0;
                }
                parent = parent.getParent();
            }
            if (!isXVMSubClass) continue;
            this.illegalClasses.add(clazz);
        }
        if (!this.pSkipNonComparedClassesValue) {
            for (RfClass clazz : this.illegalClasses) {
                this.addHit(clazz, "Class " + LintUtils.getNamedElementFullName(clazz) + " does not implement do_compare()!");
            }
        } else {
            LocalHidVisitor visitor = new LocalHidVisitor();
            RfProject rfProject = this.fOVMProject.getRfProject();
            rfProject.visitHidObject(rfProject, visitor);
        }
    }

    private void filterFunctions(List<RfFunction> compareFunctions) {
        Iterator<RfFunction> iterator = compareFunctions.iterator();
        while (iterator.hasNext()) {
            RfFunction function = iterator.next();
            FunctionVisitor visitor = new FunctionVisitor();
            function.visitHidObject(this.fOVMProject.getRfProject(), visitor);
            if (visitor.containsOtherElements()) continue;
            iterator.remove();
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private static class FunctionVisitor
    extends RfHidVisitor {
        private boolean containsOtherElements = false;

        private FunctionVisitor() {
        }

        public boolean visit(RfHid hid) {
            if (hid == null) {
                return true;
            }
            if (hid.getElement() == null) {
                return true;
            }
            IRfNamedElement element = hid.getElement();
            if (element instanceof RfSuperImplicitVariable || element instanceof RfResultImplicitVariable) {
                return true;
            }
            if (element instanceof RfFunction && element.getName().equals(CheckOVM66.DO_COMPARE)) {
                return true;
            }
            if (element instanceof RfField && (element.getName().equals("comparer") || element.getName().equals("rhs"))) {
                return true;
            }
            this.containsOtherElements = true;
            return true;
        }

        public boolean containsOtherElements() {
            return this.containsOtherElements;
        }
    }

    private class LocalHidVisitor
    extends RfHidVisitor {
        private LocalHidVisitor() {
        }

        public boolean visit(RfHid hid) {
            if (hid == null) {
                return true;
            }
            if (!(this.holder instanceof HidHolder)) {
                return true;
            }
            IRfNamedElement holderScope = ((HidHolder)this.holder).getScope();
            if (!(holderScope instanceof RfNamedElement)) {
                return true;
            }
            if (CheckOVM66.this.checkPreWaivers(((RfNamedElement)holderScope).getFile())) {
                return true;
            }
            if (CheckOVM66.this.fOVMProject.isOVMElement((RfNamedElement)holderScope)) {
                return true;
            }
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement hidNamedElement = hid.getElement();
            if (hidNamedElement == null || !(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            if (!hidNamedElement.getName().equals(CheckOVM66.DO_COMPARE)) {
                return true;
            }
            RfClass enclosingClass = (RfClass)hidNamedElement.getEnclosingScope(RfClass.class);
            Hid parentHid = hid.getParentHid();
            if (parentHid != null) {
                IRfNamedElement parentElement = parentHid.getElement();
                if (parentElement != null && parentElement instanceof RfSuperImplicitVariable && holderScope instanceof RfFunction && holderScope.getName().equals(CheckOVM66.DO_COMPARE)) {
                    return true;
                }
                if (parentElement instanceof RfAssociatedType && ((RfAssociatedType)parentElement).getAssociatedType() instanceof RfClass) {
                    enclosingClass = (RfClass)((RfAssociatedType)parentElement).getAssociatedType();
                }
            }
            if (enclosingClass == null) {
                return true;
            }
            if (CheckOVM66.this.illegalClasses.contains(enclosingClass)) {
                CheckOVM66.this.addHit(enclosingClass, "Class " + LintUtils.getNamedElementFullName(enclosingClass) + " does not implement do_compare()!");
            }
            return true;
        }
    }
}

