/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LintUtilsConstants;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="17.1.29")
@CheckID(value="XVM67")
@CheckName(value="XVM67")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.FUNCTIONAL, RuleLabel.SYNCRONIZATION, RuleLabel.COMPONENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use run phase and sub-run-phases at the same time in a component")
@CheckDescription(value="Component's run phase and sub-run-phases are executed in parallel.\nUsing them together without proper synchronization can lead to testbench bugs that are hard to debug.\nUse either run phase or sub-run-phases.\n\nCheck supports pre-waiving.")
public class CheckOVM67
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of classes full names. The check will be skipped in classes extending from the specified base classes.", name="skipBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipBaseClassesValue;

    public CheckOVM67(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        ArrayList<RfClass> skipBaseClasses = new ArrayList<RfClass>();
        for (String skipBaseClassName : this.pSkipBaseClassesValue) {
            RfClass skipBaseClass = this.fOVMProject.getRfProject().getClass(skipBaseClassName, true);
            if (skipBaseClass == null) continue;
            skipBaseClasses.add(skipBaseClass);
        }
        for (RfClass clazz : this.fOVMProject.getAllComponents().values()) {
            RfFileDef file;
            if (clazz == null || (file = clazz.getFile()) == null || file.getParserPath() == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) continue;
            this.notifyCheckAlive();
            boolean isSkippedClass = false;
            for (RfClass skipBaseClass : skipBaseClasses) {
                if (!LintUtils.isSubClassOf(clazz, skipBaseClass)) continue;
                isSkippedClass = true;
                break;
            }
            if (isSkippedClass) continue;
            RfFunction runPhaseTaskInCurrentClass = clazz.getTaskWithPrefix("run_phase", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            List<RfFunction> subRunPhasesInCurrentClass = this.getSubRunPhases(clazz);
            if (runPhaseTaskInCurrentClass == null && subRunPhasesInCurrentClass.isEmpty()) continue;
            ArrayList<RfFunction> subRunPhases = new ArrayList<RfFunction>();
            this.findSubRunPhasesInInheritanceChain(clazz, subRunPhases);
            RfFunction runPhaseTask = this.findRunPhaseInInheritanceChain(clazz);
            if (runPhaseTask == null || subRunPhases.isEmpty()) continue;
            String subRunPhasesHitMessage = subRunPhases.stream().map(func -> this.link((RfNamedElement)func)).reduce("", (a, b) -> String.valueOf(a) + " \n\t" + b);
            this.addHit(clazz, "Component '" + LintUtils.getNamedElementFullName(clazz) + "' uses both " + this.link(runPhaseTask) + " and the following sub-run-phases:" + subRunPhasesHitMessage);
        }
    }

    public void findSubRunPhasesInInheritanceChain(RfClass clazz, ArrayList<RfFunction> subRunPhases) {
        if (clazz == null) {
            return;
        }
        if (this.fOVMProject.isOVMElement(clazz)) {
            return;
        }
        List<RfFunction> classSubRunPhases = this.getSubRunPhases(clazz);
        subRunPhases.addAll(classSubRunPhases);
        this.findSubRunPhasesInInheritanceChain(clazz.getParent(), subRunPhases);
    }

    public List<RfFunction> getSubRunPhases(RfClass clazz) {
        ArrayList<RfFunction> subRunPhases = new ArrayList<RfFunction>();
        LintUtilsConstants.SUB_RUN_PHASE_FUNCTIONS.stream().map(phase -> clazz.getTaskWithPrefix((String)phase, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)).filter(Objects::nonNull).forEach(subRunPhase -> {
            boolean bl = subRunPhases.add((RfFunction)subRunPhase);
        });
        return subRunPhases;
    }

    public RfFunction findRunPhaseInInheritanceChain(RfClass childClass) {
        if (childClass == null) {
            return null;
        }
        if (this.fOVMProject.isOVMElement(childClass)) {
            return null;
        }
        RfFunction runPhaseTasks = childClass.getTaskWithPrefix("run_phase", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (runPhaseTasks != null) {
            return runPhaseTasks;
        }
        return this.findRunPhaseInInheritanceChain(childClass.getParent());
    }
}

