/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="18.1.8")
@CheckID(value="XVM68")
@CheckName(value="XVM68")
@CheckLabel(labels={RuleLabel.PERFORMANCE, RuleLabel.MESSAGING, RuleLabel.VERIFICATION})
@CheckTitle(value="Use the tree printer for objects printed often")
@CheckDescription(value="When objects need to be printed often, it is best to use the tree printer to reduce the formatting overhead but maintain a readable format.\nThe default printer is the table printer which is slower than the tree printer. The line printer has the same speed as the tree printer but a less readable result.\n\nExamples:\n\nitem.print(); // not allowed\nitem.print(uvm_default_tree_printer); // allowed\n\nif (get_report_max_verbosity_level() > UVM_HIGH)\n  item.print(); // allowed iff allowedWithVerbosityLevelGuard is true\n")
public class CheckOVM68
extends OVMComplianceCheck {
    private static final List<String> PRINT_FUNCTIONS = Arrays.asList("uvm_pkg::uvm_object.sprint", "uvm_pkg::uvm_object.print");
    private static final String TABLE_PRINTER = "uvm_pkg::uvm_table_printer";
    private static final String LINE_PRINTER = "uvm_pkg::uvm_line_printer";
    private static final String TREE_PRINTER = "uvm_pkg::uvm_tree_printer";
    private static final String DEFAULT_PRINTER = "uvm_pkg::uvm_default_printer";
    private static final String DEFAULT_TREE_PRINTER = "uvm_pkg::uvm_default_tree_printer";
    private static final String VERBOSITY_VARIABLE = "uvm_pkg::uvm_report_handler.m_max_verbosity_level";
    private static final String VERBOSITY_METHOD = "uvm_pkg::uvm_report_object.get_report_max_verbosity_level";
    @CheckParameter(defaultValue="uvm_pkg::uvm_transaction", description="For all classes that inherit from a class that has a name matching baseClassPattern.", name="baseClassPattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pBaseClassPatternValue;
    @CheckParameter(defaultValue="", description="Skip classes that inherit from a class that has a name matching skipBaseClassPattern.", name="skipBaseClassPattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pSkipBaseClassPatternValue;
    @CheckParameter(defaultValue="false", description="Allow line printer.", name="allowLinePrinter", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowLinePrinterValue;
    @CheckParameter(defaultValue="false", description="Allow using the default printer (uvm_pkg::uvm_default_printer) when it is set with a uvm_tree_printer instance.", name="allowDefaultPrinter", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowDefaultPrinter;
    @CheckParameter(defaultValue="false", description="When true usages of any printers that are guarded by a check of the verbosity level will not be reported. Only the existence of the get_report_max_verbosity_level method call or m_max_verbosity_level in the if expression is checked.", name="allowedWithVerbosityLevelGuard", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowWithVerbosityLevelGuard;
    private boolean foundAssignment;

    public CheckOVM68(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        HashMap<String, RfClass> baseClasses = new HashMap<String, RfClass>();
        HashMap<String, RfClass> skipBaseClasses = new HashMap<String, RfClass>();
        this.getAllowedBaseClasses(baseClasses, skipBaseClasses);
        if (baseClasses.isEmpty()) {
            return;
        }
        HashSet<String> allowedPrinters = new HashSet<String>();
        allowedPrinters.add(TREE_PRINTER);
        if (this.pAllowLinePrinterValue) {
            allowedPrinters.add(LINE_PRINTER);
        }
        this.foundAssignment = false;
        if (this.pAllowDefaultPrinter) {
            rfProject.visitHidObject(rfProject, (IHidVisitor<?>)new HidOperatorVisitor(null){

                public boolean visit(HidOperator operator) {
                    if (!operator.hasOccurrence(HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS) && !operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                        return true;
                    }
                    if (this.scope == null) {
                        return true;
                    }
                    IHidObject lhValue = operator.getLHValue();
                    if (!(lhValue instanceof RfHid)) {
                        return true;
                    }
                    IRfNamedElement lhElement = ((RfHid)lhValue).getElement();
                    if (!(lhElement instanceof RfField)) {
                        return true;
                    }
                    if (!((RfField)lhElement).getFullName().equals(CheckOVM68.DEFAULT_PRINTER)) {
                        return true;
                    }
                    ListContainer rhValues = operator.getRHValues();
                    if (rhValues == null || rhValues.size() != 1) {
                        return true;
                    }
                    IHidObject rhValue = (IHidObject)rhValues.get(0);
                    if (!(rhValue instanceof RfHid)) {
                        return true;
                    }
                    IRfNamedElement rhElement = ((RfHid)rhValue).getElement();
                    if (!(rhElement instanceof RfField)) {
                        return true;
                    }
                    if (((RfField)rhElement).getFullName().equals(CheckOVM68.DEFAULT_TREE_PRINTER)) {
                        CheckOVM68.this.foundAssignment = true;
                        return true;
                    }
                    RfClass classType = LintUtils.getFieldFinalClassTypeOrNull((RfField)rhElement);
                    if (classType == null) {
                        return true;
                    }
                    if (classType.isSubClass("uvm_tree_printer", true)) {
                        CheckOVM68.this.foundAssignment = true;
                        return true;
                    }
                    return true;
                }
            });
        }
        if (this.foundAssignment) {
            allowedPrinters.add(DEFAULT_PRINTER);
        }
        rfProject.visitHidObject(rfProject, new FunctionCallVisitor(baseClasses, skipBaseClasses, allowedPrinters));
    }

    private void getAllowedBaseClasses(HashMap<String, RfClass> baseClasses, HashMap<String, RfClass> skipBaseClasses) {
        for (RfClass eachClass : this.fOVMProject.getAllClasses()) {
            Matcher m;
            if (!this.pBaseClassPatternValue.pattern().isEmpty() && (m = this.pBaseClassPatternValue.matcher(eachClass.getFullName())).matches()) {
                baseClasses.put(eachClass.getFullName(), eachClass);
            }
            if (this.pSkipBaseClassPatternValue.pattern().isEmpty() || !(m = this.pSkipBaseClassPatternValue.matcher(eachClass.getFullName())).matches()) continue;
            skipBaseClasses.put(eachClass.getFullName(), eachClass);
        }
    }

    private class FunctionCallVisitor
    extends RfHidVisitor {
        private HashMap<String, RfClass> baseClasses;
        private HashMap<String, RfClass> skipBaseClasses;
        private Set<String> allowedPrinters;

        public FunctionCallVisitor(HashMap<String, RfClass> baseClasses, HashMap<String, RfClass> skipBaseClasses, Set<String> allowedPrinters) {
            this.baseClasses = baseClasses;
            this.skipBaseClasses = skipBaseClasses;
            this.allowedPrinters = allowedPrinters;
        }

        public boolean visit(RfHid hid) {
            if (hid == null) {
                return true;
            }
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            if (hidNamedElement.isPredefined()) {
                return true;
            }
            if (!(this.holder instanceof HidHolder)) {
                return true;
            }
            IRfNamedElement holderScope = ((HidHolder)this.holder).getScope();
            if (holderScope == null) {
                return true;
            }
            if (!(holderScope instanceof RfNamedElement)) {
                return true;
            }
            RfPackage enclosingPackage = (RfPackage)holderScope.getEnclosingScope(RfPackage.class);
            if (enclosingPackage != null && CheckOVM68.this.fOVMProject.isOVMElement(enclosingPackage)) {
                return true;
            }
            CheckOVM68.this.notifyCheckAlive();
            if (!this.isCalledByAllowedSubClass(hid)) {
                return true;
            }
            String hidNamedElementFullName = ((RfNamedElement)hidNamedElement).getFullName();
            if (hidNamedElementFullName == null) {
                return true;
            }
            String elementName = hidNamedElement.getName();
            if (elementName == null) {
                return true;
            }
            if (!PRINT_FUNCTIONS.contains(hidNamedElementFullName) && !"do_print".equals(elementName)) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            if (CheckOVM68.this.pAllowWithVerbosityLevelGuard) {
                RfActionBlock actionBlock = (RfActionBlock)holderScope.getEnclosingScope(RfActionBlock.class);
                while (actionBlock != null) {
                    IHidObject expression = actionBlock.getConditionalBlockExpression();
                    Set hids = HidUtils.flattenToUniqueHids((IHidObject)expression, (Set)HidFlatteningOption.IMPLICITS_SELECTS_AND_ARGS_EXCLUDED);
                    for (IHid hidInCondition : hids) {
                        if (!(hidInCondition instanceof RfHid)) continue;
                        IRfNamedElement hidElement = hidInCondition.getElement();
                        String fullName = null;
                        if (hidElement instanceof RfField) {
                            fullName = ((RfField)hidElement).getFullName();
                        }
                        if (hidElement instanceof RfFunction) {
                            fullName = ((RfFunction)hidElement).getFullName();
                        }
                        if (fullName == null || !fullName.equals(CheckOVM68.VERBOSITY_METHOD) && !fullName.equals(CheckOVM68.VERBOSITY_VARIABLE)) continue;
                        return true;
                    }
                    actionBlock = actionBlock.getEnclosingScope().getEnclosingScope(RfActionBlock.class);
                }
            }
            for (MethodCall methodCall : methodCalls) {
                if (methodCall == null) continue;
                if (methodCall.argumentValuesMap == null) {
                    if (CheckOVM68.this.foundAssignment) continue;
                    String hitMessage = "Printer 'uvm_pkg::uvm_table_printer' is used by method '" + LintUtils.getNamedElementFullName((RfNamedElement)methodCall.method) + "'!";
                    CheckOVM68.this.addHit(this.parserPath, methodCall.occurrence.getLine(), hitMessage, ((RfNamedElement)methodCall.method).getDeclaration().getReparseInfo());
                    continue;
                }
                block3: for (Map.Entry entry : methodCall.argumentValuesMap.entrySet()) {
                    Set argumentsValues = (Set)entry.getValue();
                    for (IHid argumentValue : argumentsValues) {
                        String printerClassName = this.getPrinterClassName((IHidObject)argumentValue);
                        if (printerClassName == null) continue block3;
                        if (CheckOVM68.DEFAULT_PRINTER.equals(printerClassName) && !CheckOVM68.this.foundAssignment) {
                            printerClassName = CheckOVM68.TABLE_PRINTER;
                        }
                        if (this.allowedPrinters.contains(printerClassName)) continue;
                        String hitMessage = "Printer '" + printerClassName + "' is used by method '" + LintUtils.getNamedElementFullName((RfNamedElement)methodCall.method) + "'!";
                        CheckOVM68.this.addHit(this.parserPath, methodCall.occurrence.getLine(), hitMessage, ((RfNamedElement)methodCall.method).getDeclaration().getReparseInfo());
                    }
                }
            }
            return true;
        }

        private String getPrinterClassName(IHidObject printer) {
            if (printer == null) {
                return CheckOVM68.DEFAULT_PRINTER;
            }
            switch (printer.getHidKind()) {
                case HID: {
                    IRfNamedElement printerNamedElement = ((RfHid)printer).getElement();
                    if (!(printerNamedElement instanceof RfAssociatedType)) break;
                    String printerFullName = ((RfAssociatedType)printerNamedElement).getFullName();
                    if (printerFullName != null && CheckOVM68.DEFAULT_PRINTER.equals(printerFullName)) {
                        return CheckOVM68.DEFAULT_PRINTER;
                    }
                    RfNamedElement associatedFinalType = LintUtils.getAssociatedFinalType((RfAssociatedType)printerNamedElement);
                    if (!(associatedFinalType instanceof RfClass)) break;
                    RfClass printerClass = (RfClass)associatedFinalType;
                    if (printerClass.isSubClass("uvm_table_printer", true)) {
                        return CheckOVM68.TABLE_PRINTER;
                    }
                    if (printerClass.isSubClass("uvm_line_printer", true)) {
                        return CheckOVM68.LINE_PRINTER;
                    }
                    if (printerClass.isSubClass("uvm_tree_printer", true)) {
                        return CheckOVM68.TREE_PRINTER;
                    }
                    return ((RfClass)associatedFinalType).getFullName();
                }
                case IMPLICIT: {
                    String printerName = ((RfHidImplicit)printer).getName();
                    if (printerName == null || !"null".equals(printerName)) break;
                    return CheckOVM68.DEFAULT_PRINTER;
                }
            }
            return null;
        }

        private boolean isCalledByAllowedSubClass(RfHid hid) {
            HidAccess parentAccess = hid.getParentAccess();
            if (parentAccess == null) {
                return false;
            }
            IRfNamedElement associatedType = parentAccess.getAssociatedType();
            if (associatedType instanceof RfAssociatedType) {
                associatedType = LintUtils.getAssociatedFinalType((RfAssociatedType)associatedType);
            }
            if (associatedType == null || !(associatedType instanceof RfClass)) {
                return false;
            }
            if (!((RfClass)associatedType).isSubClass("uvm_object", true)) {
                return false;
            }
            if (!LintUtils.isClassEqualOrChildOf((RfClass)associatedType, this.baseClasses)) {
                return false;
            }
            return this.skipBaseClasses.isEmpty() || !LintUtils.isClassEqualOrChildOf((RfClass)associatedType, this.skipBaseClasses);
        }
    }
}

