/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfStringType;

@CheckVersion(value="18.1.35")
@CheckID(value="XVM69")
@CheckName(value="XVM69")
@CheckLabel(labels={RuleLabel.OBJECT, RuleLabel.CONSTRUCTOR, RuleLabel.ARGUMENT, RuleLabel.VERIFICATION})
@CheckTitle(value="XVM object constructor argument must have an empty string as default value")
@CheckDescription(value="XVM object constructor argument must have an empty string as default value.")
public class CheckOVM69
extends OVMComplianceCheck {
    public CheckOVM69(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        final RfClass xvmObject = this.fOVMProject.getLibraryKind() == 2 ? this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_object", true) : this.fOVMProject.getRfProject().getClass("ovm_pkg::ovm_object", true);
        if (xvmObject == null) {
            return;
        }
        try {
            this.fOVMProject.getRfProject().accept(new IRfNamedElementVisitor(){

                @Override
                public boolean visit(RfNamedElement namedElement) {
                    if (!(namedElement instanceof RfFunction)) {
                        return true;
                    }
                    RfFunction function = (RfFunction)namedElement;
                    if (!function.isConstructor()) {
                        return true;
                    }
                    RfNamedElement enclosingScope = function.getEnclosingScope();
                    if (!(enclosingScope instanceof RfClass)) {
                        return true;
                    }
                    if (!((RfClass)enclosingScope).isSubClass(xvmObject)) {
                        return true;
                    }
                    RfField argument = function.getArgumentWithPrefix("", 2);
                    if (argument == null) {
                        return true;
                    }
                    CheckOVM69.this.notifyCheckAlive();
                    IRfNamedElement argumentType = argument.getAssociatedType();
                    if (argumentType instanceof RfTypeAlias) {
                        argumentType = ((RfTypeAlias)argumentType).getTranslatedType();
                    }
                    if (!(argumentType instanceof RfStringType)) {
                        return true;
                    }
                    String initialValue = argument.getInitialValue(false);
                    if (initialValue == null || initialValue.equals("\"\"")) {
                        return true;
                    }
                    CheckOVM69.this.addHit(function, "The class '" + LintUtils.getNamedElementFullName(enclosingScope) + "' constructor's argument '" + argument.getName() + "' default value is not an empty string!");
                    return true;
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

