/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractMacroUseCheck;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="3.1")
@CheckID(value="XVM7")
@CheckName(value="XVM7")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.UVM_DO, RuleLabel.MACRO, RuleLabel.VERIFICATION})
@CheckTitle(value="Sequences must call inside the body() the `xvm_do macro")
@CheckDescription(value="Check inside the body() the usage of `xvm_do or `xvm_do_with macros or any \"sub do\" macro, like `xvm_create. See the XVM reference manual for all sub-macro definitions.\n\nCheck supports pre-waiving.")
public class CheckOVM7
extends AbstractMacroUseCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of patterns to match the full name of sequences in which to skip checking.", name="skipSequenceNamePatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pSkipSequenceNamePatterns;

    public CheckOVM7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        HashSet<String> relevantMacros = new HashSet<String>();
        relevantMacros.addAll(Arrays.asList(XVMMacros.OVM_SEQUENCE_BODY_MACROS));
        relevantMacros.addAll(Arrays.asList(XVMMacros.UVM_SEQUENCE_BODY_MACROS));
        aRfProject.lintTrackMacrosByNames("task", relevantMacros);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequences.isEmpty()) {
            return;
        }
        boolean isOVMLib = this.fOVMProject.getLibraryKind() == 1;
        String[] libSequenceBodyMacros = isOVMLib ? XVMMacros.OVM_SEQUENCE_BODY_MACROS : XVMMacros.UVM_SEQUENCE_BODY_MACROS;
        String macroNameInHitMessage = isOVMLib ? "`ovm_do_* or \"sub do\"" : "`uvm_do_* or \"sub do\"";
        Collection<RfClass> sequences = this.fOVMProject.fSequences.values();
        if (!this.pSkipSequenceNamePatterns.isEmpty()) {
            Iterator<RfClass> itr = sequences.iterator();
            block0: while (itr.hasNext()) {
                RfClass sequence = itr.next();
                for (Pattern pattern : this.pSkipSequenceNamePatterns) {
                    if (!pattern.matcher(sequence.getName()).matches()) continue;
                    itr.remove();
                    continue block0;
                }
            }
        }
        this.checkMacrosInClassesAndFunction(sequences, "body", new HashSet<String>(Arrays.asList(libSequenceBodyMacros)), macroNameInHitMessage);
    }
}

