/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.39")
@CheckID(value="XVM70")
@CheckName(value="XVM70")
@CheckLabel(labels={RuleLabel.OBJECTION, RuleLabel.VERIFICATION})
@CheckTitle(value="Always pass a string as a description argument when calling raise_objection() or drop_objection()")
@CheckDescription(value="Always pass a string as a description argument when calling raise_objection() or drop_objection(), this will help when debugging objections.\nCheck all raise_objection() and drop_objection() calls on xvm_objection and xvm_phase based classes. \n\nCheck supports pre-waiving.")
public class CheckOVM70
extends OVMComplianceCheck {
    public CheckOVM70(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass xvmObjection;
        RfClass xvmPhase;
        if (this.fOVMProject.getLibraryKind() == 2) {
            xvmPhase = this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_phase", true);
            xvmObjection = this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_objection", true);
        } else {
            xvmPhase = null;
            xvmObjection = this.fOVMProject.getRfProject().getClass("ovm_pkg::ovm_objection", true);
        }
        if (xvmObjection == null) {
            return;
        }
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<IHidObject>(){
            ParserPath parserPath;

            public boolean visit(IHidObject hidObject) {
                if (!(hidObject instanceof RfHid)) {
                    return true;
                }
                IRfNamedElement element = ((RfHid)hidObject).getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                RfFunction function = (RfFunction)element;
                if (!function.isFunction()) {
                    return true;
                }
                if (CheckOVM70.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                RfDefElement declaration = function.getDeclaration();
                if (declaration == null) {
                    return true;
                }
                RfNamedElement functionDeclaration = declaration.getNamedElement();
                if (!(functionDeclaration instanceof RfFunction)) {
                    return true;
                }
                RfNamedElement enclosingScope = functionDeclaration.getEnclosingScope();
                if (!(enclosingScope instanceof RfClass)) {
                    return true;
                }
                CheckOVM70.this.notifyCheckAlive();
                if (xvmPhase != null ? !enclosingScope.equals(xvmPhase) && !((RfClass)enclosingScope).isSubClass(xvmPhase) && !enclosingScope.equals(xvmObjection) && !((RfClass)enclosingScope).isSubClass(xvmObjection) : !enclosingScope.equals(xvmObjection) && !((RfClass)enclosingScope).isSubClass(xvmObjection)) {
                    return true;
                }
                if (!function.getName().equals("raise_objection") && !function.getName().equals("drop_objection")) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)((RfHid)hidObject));
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return true;
                }
                for (MethodCall methodCall : methodCalls) {
                    if (methodCall.argumentValuesMapRaw == null) continue;
                    boolean hasDescription = false;
                    for (Map.Entry argument : methodCall.argumentValuesMapRaw.entrySet()) {
                        DataType dataType;
                        IRfNamedElement functionArgument;
                        if (!(argument.getKey() instanceof RfField) || !((IRfFieldElement)argument.getKey()).getName().equals("description")) continue;
                        IHidObject value = (IHidObject)argument.getValue();
                        if (value instanceof RfHid || value instanceof RfHidImplicit && !((RfHidImplicit)value).getName().equals("\"\"") && !((RfHidImplicit)value).getName().equals("null")) {
                            hasDescription = true;
                            continue;
                        }
                        if (value instanceof RfHidOperator && ((RfHidOperator)value).isVLOGConcatenation(true)) {
                            hasDescription = true;
                            continue;
                        }
                        if (value instanceof RfHidAccessArgs) {
                            value = ((RfHidAccessArgs)value).getParentHid();
                        }
                        if (!(value instanceof RfHid) || !((functionArgument = ((RfHid)value).getElement()) instanceof RfFunction) || (dataType = ((RfFunction)functionArgument).getDataType()) == null || !"string".equals(dataType.getType())) continue;
                        hasDescription = true;
                    }
                    if (hasDescription) continue;
                    CheckOVM70.this.addHit(this.parserPath, methodCall.occurrence, "'" + LintUtils.getNamedElementFullName((RfNamedElement)methodCall.method) + "()' is called without passing the description argument!");
                }
                return true;
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

