/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

@CheckVersion(value="20.1.27")
@CheckID(value="XVM71")
@CheckName(value="XVM71")
@CheckLabel(labels={RuleLabel.TLM_PORT, RuleLabel.VERIFICATION})
@CheckTitle(value="All TLM ports must be connected")
@CheckDescription(value="This check verifies all TLM ports declared inside the project, and flags the ones that are initialized but never connected.\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class CheckOVM71
extends OVMComplianceCheck {
    public CheckOVM71(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String lib = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "");
        HashSet<RfNamedElement> allPorts = this.getAllPorts();
        HashSet<RfNamedElement> initializedPorts = new HashSet<RfNamedElement>();
        TLMConnectionVisitor connectionVisitor = new TLMConnectionVisitor(allPorts, initializedPorts, lib);
        this.fOVMProject.getRfProject().visitHidObject(null, connectionVisitor);
        for (RfNamedElement rfNamedElement : allPorts) {
            if (!initializedPorts.contains(rfNamedElement)) continue;
            this.addHit(rfNamedElement, "Port " + rfNamedElement.getFullName() + " is never connected!");
        }
    }

    public HashSet<RfNamedElement> getAllPorts() {
        HashSet<RfNamedElement> allPorts = new HashSet<RfNamedElement>();
        for (RfNamedElement rfNamedElement : this.fOVMProject.getAllFields()) {
            RfNamedElement associatedType;
            if (!(rfNamedElement instanceof RfField) || !((associatedType = LintUtils.getAssociatedFinalType((RfField)rfNamedElement)) instanceof RfClass) || !((RfClass)associatedType).isSubClass(this.fOVMProject.getLibraryKind() == 1 ? "ovm_port_base" : "uvm_port_base", true)) continue;
            allPorts.add(rfNamedElement);
        }
        return allPorts;
    }

    protected boolean pathIsPrewaived(ParserPath path) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }

    private class TLMConnectionVisitor
    implements IHidVisitor<RfHid> {
        private RfNamedElement scope;
        private ParserPath parserPath;
        public HashSet<RfNamedElement> unconnectedPorts;
        public HashSet<RfNamedElement> newPorts;
        public String lib;

        public TLMConnectionVisitor(HashSet<RfNamedElement> unconnectedPorts, HashSet<RfNamedElement> initializedPorts, String lib) {
            this.unconnectedPorts = unconnectedPorts;
            this.newPorts = initializedPorts;
            this.lib = lib;
        }

        public boolean visit(RfHid hidObject) {
            RfHid parentHid;
            RfFileDef file = this.scope.getFile();
            if (file == null) {
                return true;
            }
            CheckOVM71.this.notifyCheckAlive();
            if (CheckOVM71.this.pathIsPrewaived(this.parserPath)) {
                return true;
            }
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (element instanceof RfFunction && (parentHid = (RfHid)hidObject.getParentHid()) != null && parentHid.getElement() instanceof RfField && this.isTLMPortType(parentHid.getElement())) {
                if (((RfFunction)element).isConstructor()) {
                    this.newPorts.add((RfNamedElement)parentHid.getElement());
                    return true;
                }
                if (!((RfFunction)element).getFullName().equals(String.valueOf(this.lib) + "_pkg::" + this.lib + "_port_base.connect")) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
                for (MethodCall methodCall : methodCalls) {
                    if (methodCall.argumentValuesMapRaw == null) continue;
                    for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                        IHidObject argValue = (IHidObject)entry.getValue();
                        if (argValue instanceof RfHidAccess && ((RfHidAccess)argValue).getParentHid() != null) {
                            argValue = ((RfHidAccess)argValue).getParentHid();
                        }
                        if (!(argValue instanceof RfHid) || ((RfHid)argValue).getElement() == null) continue;
                        this.unconnectedPorts.remove(((RfHid)argValue).getElement());
                    }
                }
                this.unconnectedPorts.remove(parentHid.getElement());
            }
            return true;
        }

        private boolean isTLMPortType(IRfNamedElement element) {
            if (!(element instanceof RfField)) {
                return false;
            }
            RfNamedElement associatedType = LintUtils.getAssociatedFinalType((RfField)element);
            if (!(associatedType instanceof RfClass)) {
                return false;
            }
            return ((RfClass)associatedType).isSubClass(CheckOVM71.this.fOVMProject.getLibraryKind() == 1 ? "ovm_port_base" : "uvm_port_base", true);
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

