/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;

@CheckVersion(value="3.1")
@CheckID(value="XVM8")
@CheckName(value="XVM8")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="pre_body(), post_body()")
@CheckDescription(value="If the methods pre_body() and post_body() are implemented on a sequence, they must include respectively the super.pre_body() and super.post_body().\n\nException: Virtual sequences are not checked.\n\nCheck supports pre-waiving.")
public class CheckOVM8
extends OVMComplianceCheck {
    public CheckOVM8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequences.isEmpty()) {
            return;
        }
        for (RfClass sequence : this.fOVMProject.fSequences.values()) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(sequence.getFile()) || sequence.hasVirtualQualifier() || this.fOVMProject.isOVMElement(sequence)) continue;
            boolean found = false;
            if (this.checkMethod(sequence, "pre_body")) {
                found = true;
            }
            if (this.checkMethod(sequence, "post_body")) {
                found = true;
            }
            if (found) continue;
            this.addPassedHit(sequence, "pre_body() and post_body() methods not found");
        }
    }

    private boolean checkMethod(RfClass sequence, String methodName) {
        List<RfFunction> candidates = sequence.getFunctionsWithPrefix(methodName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (candidates == null || candidates.isEmpty()) {
            candidates = sequence.getTasksWithPrefix(methodName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        }
        if (candidates != null && !candidates.isEmpty()) {
            List<RfFunctionCall> callCandidates = candidates.get(0).getFunctionCallsWithPrefix("super." + methodName, 1);
            if (callCandidates == null || callCandidates.isEmpty()) {
                this.addHit(candidates.get(0), "Method " + methodName + "() doesn't call super." + methodName + "()");
            } else {
                this.addPassedHit(callCandidates.get(0), "Method " + methodName + "() calls super." + methodName + "()");
            }
            return true;
        }
        return false;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

