/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractNamePatternParametersCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="3.1")
@CheckID(value="XVM9")
@CheckName(value="XVM9")
@CheckLabel(labels={RuleLabel.COMPONENT, RuleLabel.BASE_CLASS, RuleLabel.OVERRIDE, RuleLabel.VERIFICATION})
@CheckTitle(value="Base Class")
@CheckDescription(value="All components implemented must be extended from the corresponding base class or a derivate of it, for example the monitor must be extended from xvm_monitor or its derivative.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="testClassNamePattern", isVisible=true), @CheckParameterOverride(name="envClassNamePattern", isVisible=true), @CheckParameterOverride(name="agentClassNamePattern", isVisible=true), @CheckParameterOverride(name="monitorClassNamePattern", isVisible=true), @CheckParameterOverride(name="driverClassNamePattern", isVisible=true), @CheckParameterOverride(name="sequencerClassNamePattern", isVisible=true), @CheckParameterOverride(name="scoreboardClassNamePattern", isVisible=true)})
public class CheckOVM9
extends AbstractNamePatternParametersCheck {
    public CheckOVM9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.getClassesWithPatterns("testClassNamePattern").isEmpty() && this.getClassesWithPatterns("envClassNamePattern").isEmpty() && this.getClassesWithPatterns("agentClassNamePattern").isEmpty() && this.getClassesWithPatterns("monitorClassNamePattern").isEmpty() && this.getClassesWithPatterns("driverClassNamePattern").isEmpty() && this.getClassesWithPatterns("sequencerClassNamePattern").isEmpty() && this.getClassesWithPatterns("scoreboardClassNamePattern").isEmpty()) {
            return;
        }
        this.performComponentsCheck(this.getClassesWithPatterns("testClassNamePattern"), this.fOVMProject.fOvmTest);
        this.performComponentsCheck(this.getClassesWithPatterns("envClassNamePattern"), this.fOVMProject.fOvmEnv);
        this.performComponentsCheck(this.getClassesWithPatterns("agentClassNamePattern"), this.fOVMProject.fOvmAgent);
        this.performComponentsCheck(this.getClassesWithPatterns("monitorClassNamePattern"), this.fOVMProject.fOvmMonitor);
        this.performComponentsCheck(this.getClassesWithPatterns("driverClassNamePattern"), this.fOVMProject.fOvmDriver);
        this.performComponentsCheck(this.getClassesWithPatterns("sequencerClassNamePattern"), this.fOVMProject.fOvmSequencer);
        this.performComponentsCheck(this.getClassesWithPatterns("scoreboardClassNamePattern"), this.fOVMProject.fOvmScoreboard);
    }

    private void performComponentsCheck(Map<String, RfClass> components, RfClass baseClass) {
        if (baseClass == null) {
            return;
        }
        this.notifyCheckAlive();
        for (RfClass clazz : components.values()) {
            if (LintUtils.isSubClassOf(clazz, baseClass)) {
                this.addPassedHit(clazz, "'" + clazz.getName() + "' extends '" + baseClass.getName() + "'");
                continue;
            }
            this.addHit(clazz, "'" + clazz.getName() + "' does not extend '" + baseClass.getName() + "'");
        }
    }
}

