/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="3.1")
@CheckID(value="PKFN")
@CheckName(value="PKFN")
@CheckLabel(labels={RuleLabel.PACKAGE, RuleLabel.FILE, RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Valid File Names")
@CheckDescription(value="Verify that all source code files in a package have a name that starts with the package name.\n\nCheck supports pre-waiving.")
public class CheckPKFN
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of class full names for which the files that contain inherited classes are skipped.", name="skipBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pSkipBaseClasses;

    public CheckPKFN(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashMap<ParserPath, String> filePackageMap = new HashMap<ParserPath, String>();
        RfProject rfProject = this.fOVMProject.getRfProject();
        List<RfPackage> allPackages = rfProject.getAllPackages(true);
        if (allPackages != null) {
            for (RfPackage rfPackage : allPackages) {
                ParserPath packageParserPath;
                RfFileDef rfPackageDefFile;
                if (rfPackage == null) continue;
                String packageName = rfPackage.getName();
                RfDefElement rfPackageDeclaration = rfPackage.getDeclaration();
                if (rfPackageDeclaration == null || (rfPackageDefFile = rfPackageDeclaration.getDefFile()) == null || filePackageMap.containsKey(packageParserPath = rfPackageDefFile.getParserPath())) continue;
                filePackageMap.put(packageParserPath, packageName);
            }
        }
        HashSet<RfClass> baseClasses = new HashSet<RfClass>();
        HashSet<ParserPath> excludedPaths = new HashSet<ParserPath>();
        if (this.pSkipBaseClasses != null && !this.pSkipBaseClasses.isEmpty()) {
            for (String baseClassName : this.pSkipBaseClasses) {
                RfClass baseClass = this.fOVMProject.getRfProject().getClass(baseClassName, false);
                if (baseClass == null) continue;
                baseClasses.add(baseClass);
            }
            for (RfClass baseClass : baseClasses) {
                Set<RfClass> childClasses = baseClass.getChildren();
                if (childClasses == null || childClasses.isEmpty()) continue;
                for (RfClass clazz : childClasses) {
                    excludedPaths.add(clazz.getFile().getParserPath());
                }
            }
        }
        HashSet<ParserPath> fileNames = this.fOVMProject.getAllImportedFiles();
        for (ParserPath parserPath : fileNames) {
            File file;
            String name;
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            String packageName = null;
            String packageNameAlt = null;
            if (this.pSkipBaseClasses != null && !this.pSkipBaseClasses.isEmpty() && excludedPaths.contains(parserPath)) continue;
            if (filePackageMap.containsKey(parserPath)) {
                packageName = (String)filePackageMap.get(parserPath);
            } else {
                List<RfNamedElement> namedElements;
                RfFileDef fileDef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(parserPath);
                if (fileDef != null && (namedElements = fileDef.getNamedElements()) != null) {
                    int i = 0;
                    while (i < namedElements.size()) {
                        RfNamedElement rfNamedElement = namedElements.get(i);
                        if (rfNamedElement != null && rfNamedElement instanceof RfPackage && rfNamedElement.getName() != null) {
                            packageName = rfNamedElement.getName();
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (packageName != null && packageName.endsWith("_pkg")) {
                packageNameAlt = packageName.substring(0, packageName.length() - 4);
            }
            if (packageName == null || (name = (file = new File(parserPath.path)).getName()).startsWith(packageName) || packageNameAlt != null && name.startsWith(packageNameAlt)) continue;
            this.addHit(parserPath, 0, "'" + name + "' 's name should start with '" + packageName + (packageNameAlt == null ? "'!" : "' or '" + packageNameAlt + "'!"), null);
        }
    }
}

