/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.io.File;
import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="3.1")
@CheckID(value="PKLD")
@CheckName(value="PKLD")
@CheckLabel(labels={RuleLabel.PACKAGE, RuleLabel.FILE, RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Legal Directory Name")
@CheckDescription(value="Verify that the package directory is named consistently with the package name.\n\nImplementation details:\nAssuming a package test_pkg is defined in test_pkg.sv (the file name is irrelevant for this check):\n- .../test_pkg/test_pkg.sv // LEGAL\n- .../test/test_pkg.sv // LEGAL, _pkg is stripped \n- .../test_pkg/sv/test_pkg.sv // LEGAL, one sub-folder is allowed for 'sv' or 'src' \n- .../test_pkg/sv/test_pkg.sv // LEGAL, _pkg is stripped and subfolder is legal \n- .../test_pkg/blabla/test_pkg.sv // LEGAL, _pkg is stripped and subfolder is legal \n- .../bla/test_pkg.sv // ILLEGAL\n- .../bla/sv/test_pkg.sv // ILLEGAL")
public class CheckPKLD
extends OVMComplianceCheck {
    public CheckPKLD(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        List<RfPackage> allPackages = rfProject.getAllPackages(true);
        if (allPackages == null) {
            return;
        }
        for (RfPackage rfPackage : allPackages) {
            RfFileDef rfPackageDefFile;
            RfDefElement rfPackageDeclaration;
            if (rfPackage == null || rfPackage.getName() == null) continue;
            this.notifyCheckAlive();
            String packageName = rfPackage.getName();
            String packageNameAlt = null;
            if (packageName != null && packageName.endsWith("_pkg")) {
                packageNameAlt = packageName.substring(0, packageName.length() - 4);
            }
            if ((rfPackageDeclaration = rfPackage.getDeclaration()) == null || (rfPackageDefFile = rfPackageDeclaration.getDefFile()) == null) continue;
            ParserPath packageParserPath = rfPackageDefFile.getParserPath();
            File packageFile = new File(packageParserPath.path);
            File packageDir = packageFile.getParentFile();
            String packageDirName = packageDir.getName();
            if (packageDirName == null || packageDirName.startsWith(packageName) || packageNameAlt != null && packageDirName.startsWith(packageNameAlt)) continue;
            packageDirName = (packageDir = packageDir.getParentFile()).getName();
            if (packageDirName == null) {
                this.addHit(rfPackage, "Enclosing directory of '" + this.link(packageParserPath.path, packageParserPath.path, 0) + "' must be named consistently with the package!");
                continue;
            }
            if (packageDirName.startsWith(packageName) || packageNameAlt != null && packageDirName.startsWith(packageNameAlt)) continue;
            this.addHit(rfPackage, "Enclosing directory of '" + this.link(packageParserPath.path, packageParserPath.path, 0) + "' must be named consistently with the package!");
        }
    }
}

