/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.io.File;
import ro.amiq.vlogdt.linter.AbstractFileCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;

@CheckVersion(value="3.1")
@CheckID(value="PKVD")
@CheckName(value="PKVD")
@CheckLabel(labels={RuleLabel.PACKAGE, RuleLabel.FILE})
@CheckTitle(value="Valid Directory Structure")
@CheckDescription(value="Verify that the package's directory is structured correctly (i.e. contains the example and docs directories and the source directory sv/e/sc)")
public class CheckPKVD
extends AbstractFileCheck {
    public CheckPKVD(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        File projectDirectory = OVMUtils.getProjectPath(this.fOVMProject.getProject());
        if (projectDirectory == null || !projectDirectory.exists() || !projectDirectory.isDirectory()) {
            return;
        }
        this.checkForFile("docs", projectDirectory, true, false);
        this.checkForFile("examples", projectDirectory, true, false);
        this.checkForFile("sv", projectDirectory, true, false);
    }
}

