/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.io.File;
import ro.amiq.vlogdt.linter.AbstractFileCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;

@CheckVersion(value="3.1")
@CheckID(value="PKVR")
@CheckName(value="PKVR")
@CheckLabel(labels={RuleLabel.PACKAGE, RuleLabel.FILE})
@CheckTitle(value="Valid README File")
@CheckDescription(value="Verify that there is a legal PACKAGE_README.txt file at the top level of the package.")
public class CheckPKVR
extends AbstractFileCheck {
    public CheckPKVR(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        File projectDirectory = OVMUtils.getProjectPath(this.fOVMProject.getProject());
        if (projectDirectory == null || !projectDirectory.exists() || !projectDirectory.isDirectory()) {
            return;
        }
        this.checkForFile("PACKAGE_README.TXT", projectDirectory, false, false);
    }
}

