/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Collection;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1")
@CheckID(value="SQSD")
@CheckName(value="SQSD")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.VIRTUAL_SEQUENCER})
@CheckTitle(value="Sub-sequencers in Virtual Sequencers")
@CheckDescription(value="Verify that all virtual sequencers have sub-sequencers. Sub-sequencers are associated with the virtual sequencer by declaring the sub-sequencer fields in the declaration of the virtual sequencer and then performing the assignment in the connect phase of a parent component, which also created the virtual sequencer.\n\nCheck supports pre-waiving.")
public class CheckSQSD
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, virtual sequencers will be considered as sequencers with default parameters.", name="allowVirtualSequencersWithDefaultParameters", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowVirtualSequencersWithDefaultParameters;

    public CheckSQSD(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Collection<Object> virtualSequencers;
        if (this.pAllowVirtualSequencersWithDefaultParameters) {
            virtualSequencers = new NullProtectedList();
            for (RfNamedElement rfNamedElement : this.fOVMProject.getAllNonXVMClasses()) {
                if (!(rfNamedElement instanceof RfClass) || !LintUtils.isVirtualSequencer((RfClass)rfNamedElement, this.fOVMProject.fOvmSequencer, this.fOVMProject.fOvmSequenceItem)) continue;
                virtualSequencers.add((RfClass)rfNamedElement);
            }
        } else {
            virtualSequencers = this.fOVMProject.getVirtualSequencers().values();
        }
        if (virtualSequencers.isEmpty()) {
            return;
        }
        for (RfClass rfClass : virtualSequencers) {
            if (this.checkPreWaivers(rfClass.getFile())) continue;
            List<RfField> subSequencers = rfClass.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (subSequencers == null || subSequencers.isEmpty()) {
                this.addHit(rfClass, "Virtual sequencer '" + rfClass.getName() + "' has no subsequencers");
                continue;
            }
            this.notifyCheckAlive();
            boolean hasSubsequencers = false;
            for (RfField candidate : subSequencers) {
                RfClass candidateType = LintUtils.getFieldFinalClassTypeOrNull(candidate);
                if (candidateType == null || !this.fOVMProject.isSequencer(candidateType)) continue;
                hasSubsequencers = true;
                break;
            }
            if (!hasSubsequencers) {
                this.addHit(rfClass, "Virtual sequencer '" + rfClass.getName() + "' has no subsequencers");
                continue;
            }
            List<RfFunctionCall> assignments = null;
            RfNamedElement realParentComponent = null;
            RfNamedElement virtualSeqFieldInParentComponent = null;
            for (RfNamedElement field : this.fOVMProject.getAllFields()) {
                List<RfFunctionCall> createCalls;
                List<RfFunction> buildFun;
                RfNamedElement parentComponent;
                RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull((RfField)field);
                if (fieldType == null || !fieldType.getName().equals(rfClass.getName()) || (parentComponent = field.getEnclosingScope()) == null || !(parentComponent instanceof RfClass) || (buildFun = parentComponent.getFunctionsWithPrefix("build", 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) == null || buildFun.isEmpty() || (createCalls = buildFun.get(0).getFunctionCallsWithPrefix(String.valueOf(rfClass.getName()) + "::" + "type_id::create", 1)) == null || createCalls.isEmpty()) continue;
                realParentComponent = parentComponent;
                virtualSeqFieldInParentComponent = field;
                List<RfFunction> connectFun = parentComponent.getFunctionsWithPrefix("connect", 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                if (connectFun == null || connectFun.isEmpty() || (assignments = connectFun.get(0).getFunctionCallsWithPrefix("", 2)) == null) break;
            }
            if (realParentComponent == null) {
                this.addHit(rfClass, "Virtual sequencer '" + rfClass.getName() + "' is not correctly created in its parent component");
                continue;
            }
            if (virtualSeqFieldInParentComponent == null) continue;
            for (RfField candidate : subSequencers) {
                RfClass candidateType = LintUtils.getFieldFinalClassTypeOrNull(candidate);
                if (candidateType == null || !this.fOVMProject.isSequencer(candidateType)) continue;
                boolean subSequencerOK = false;
                if (assignments != null) {
                    for (RfFunctionCall assigment : assignments) {
                        String leftValue = assigment.getLValue();
                        if (leftValue == null || !leftValue.equals(String.valueOf(virtualSeqFieldInParentComponent.getName()) + "." + candidate.getName())) continue;
                        this.addPassedHit(candidate, "'" + candidate.getName() + "' is subsequencer of '" + rfClass.getName() + "'");
                        subSequencerOK = true;
                        break;
                    }
                }
                if (subSequencerOK) continue;
                this.addHit(candidate, "'" + candidate.getName() + "' subsequencer is not correctly connected in parent component '" + realParentComponent.getName() + "'");
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

