/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Arrays;
import java.util.HashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractUtilsMacroCheck;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="3.1")
@CheckID(value="XVM10")
@CheckName(value="XVM10")
@CheckLabel(labels={RuleLabel.FACTORY_REGISTRATION, RuleLabel.SEQUENCER, RuleLabel.REGISTRATION_MACRO, RuleLabel.VERIFICATION})
@CheckTitle(value="Sequencer Factory Registration")
@CheckDescription(value="For sequencer or virtual sequencer declaration, check the existence and consistence of `uvm_component_utils (<class name declaration>).\n\nFor parameterized classes `uvm_component_param_utils or `uvm_component_param_utils_begin should be used.\n\nIf `uvm_component_utils_begin macro is used the existence of `uvm_component_utils_end must be checked.\n\nIf the pair of _begin _end is satisfied, check that between the two macro calls the `uvm_field_<type> (<variable or instance name match>, <UVM_FLAG>) may optionally exist.")
public class CheckUVM10
extends AbstractUtilsMacroCheck {
    public CheckUVM10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        HashSet<String> relevantMacros = new HashSet<String>();
        relevantMacros.addAll(Arrays.asList(XVMMacros.OVM_CLASS_MACROS));
        relevantMacros.addAll(Arrays.asList(XVMMacros.UVM_CLASS_MACROS));
        aRfProject.lintTrackMacrosByNames("class", relevantMacros);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequencers.isEmpty()) {
            return;
        }
        String libSequencerUtils = "`ovm_sequencer_utils";
        String libSequencerUtilsBegin = "`ovm_sequencer_utils_begin";
        String libSequencerUtilsEnd = "`ovm_sequencer_utils_end";
        String libSequencerParamUtils = "`ovm_sequencer_param_utils";
        String libSequencerParamUtilsBegin = "`ovm_sequencer_param_utils_begin";
        HashSet<String> libComponentsUtils = new HashSet<String>(Arrays.asList("`uvm_component_utils", "`uvm_component_abstract_utils"));
        HashSet<String> libComponentsParamUtils = new HashSet<String>(Arrays.asList("`uvm_component_param_utils", "`uvm_component_abstract_param_utils"));
        HashSet<String> libComponentsUtilsBegin = new HashSet<String>(Arrays.asList("`uvm_component_utils_begin", "`uvm_component_abstract_utils_begin"));
        String libComponentsUtilsEnd = "`uvm_component_utils_end";
        HashSet<String> libComponentsParamUtilsBegin = new HashSet<String>(Arrays.asList("`uvm_component_param_utils_begin", "`uvm_component_abstract_param_utils_begin"));
        if (this.fOVMProject.getLibraryKind() == 1) {
            this.checkMacroUtilsBeginEnd(this.fOVMProject.fSequencers, libSequencerUtils, libSequencerUtilsBegin, libSequencerUtilsEnd, libSequencerParamUtils, libSequencerParamUtilsBegin, false);
        } else {
            this.checkMacroUtilsBeginEnd(this.fOVMProject.fSequencers, libComponentsUtils, libComponentsUtilsBegin, libComponentsUtilsEnd, libComponentsParamUtils, libComponentsParamUtilsBegin, true);
        }
    }
}

