/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Arrays;
import java.util.HashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractUtilsMacroCheck;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="3.1")
@CheckID(value="XVM2")
@CheckName(value="XVM2")
@CheckLabel(labels={RuleLabel.FACTORY_REGISTRATION, RuleLabel.REGISTRATION_MACRO, RuleLabel.COMPONENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Recommended use of the factory registration macros")
@CheckDescription(value="For the declaration of monitor, sequencer, driver, agent, environment, test and data items, check respectively the existence and consistency of:\n\n`xvm_component_utils (<class name declaration>) for classes derived from xvm_component\n`xvm_component_utils (<class name declaration>) for sequencers\n`xvm_object_utils (<class name declaration>, <sequencer name>) for sequences\n`xvm_object_utils (<class name declaration>) for classes sequence items\n\nFor parameterized classes `xvm_*_param_utils or `xvm_*_param_utils_begin should be used.\n\nIf `xvm_(object or component)_utils_begin macro is used the existence of `xvm_(object or component)_utils_end must be checked.\n\nIf the pair of _begin _end is satisfied, between the two macro call the `xvm_field_<type> (<variable or instance name match>, <UVM_FLAG>) may (but not necessarily) exist.\nRefer to XVM reference manual for all supported types, with particular attention to the enum type which requires the extra field for the enum type name, and the XVM_FLAG.\n\nException: Virtual classes are not checked.\n\nWhen applying this rule for OVM library, the following are checked:\n\n`ovm_sequencer_utils (<class name declaration>) for sequencers\n`ovm_sequence_utils (<class name declaration>, <sequencer name>) for sequences")
@CheckParameterOverride(name="testbenchClassNamePattern", isVisible=true)
public class CheckUVM2
extends AbstractUtilsMacroCheck {
    public CheckUVM2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        HashSet<String> relevantMacros = new HashSet<String>();
        relevantMacros.addAll(Arrays.asList(XVMMacros.OVM_CLASS_MACROS));
        relevantMacros.addAll(Arrays.asList(XVMMacros.UVM_CLASS_MACROS));
        aRfProject.lintTrackMacrosByNames("class", relevantMacros);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fTests.isEmpty() && this.fOVMProject.fEnvs.isEmpty() && this.fOVMProject.fAgents.isEmpty() && this.fOVMProject.fMonitors.isEmpty() && this.fOVMProject.fDrivers.isEmpty() && this.fOVMProject.fSequencers.isEmpty() && this.getClassesWithPatterns("testbenchClassNamePattern").isEmpty() && this.fOVMProject.fSequenceItems.isEmpty() && this.fOVMProject.fSequences.isEmpty()) {
            return;
        }
        boolean isOVMLib = this.fOVMProject.getLibraryKind() == 1;
        HashSet<String> libComponentsUtils = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_component_utils") : Arrays.asList("`uvm_component_utils", "`uvm_component_abstract_utils"));
        HashSet<String> libComponentsParamUtils = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_component_param_utils") : Arrays.asList("`uvm_component_param_utils", "`uvm_component_abstract_param_utils"));
        HashSet<String> libComponentsUtilsBegin = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_component_utils_begin") : Arrays.asList("`uvm_component_utils_begin", "`uvm_component_abstract_utils_begin"));
        String libComponentsUtilsEnd = isOVMLib ? "`ovm_component_utils_end" : "`uvm_component_utils_end";
        HashSet<String> libComponentsParamUtilsBegin = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_component_param_utils_begin") : Arrays.asList("`uvm_component_param_utils_begin", "`uvm_component_abstract_param_utils_begin"));
        String libSequencerUtils = "`ovm_sequencer_utils";
        String libSequencerUtilsBegin = "`ovm_sequencer_utils_begin";
        String libSequencerUtilsEnd = "`ovm_sequencer_utils_end";
        String libSequencerParamUtils = "`ovm_sequencer_param_utils";
        String libSequencerParamUtilsBegin = "`ovm_sequencer_param_utils_begin";
        HashSet<String> libObjectUtils = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_object_utils") : Arrays.asList("`uvm_object_utils", "`uvm_object_abstract_utils"));
        HashSet<String> libObjectUtilsBegin = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_object_utils_begin") : Arrays.asList("`uvm_object_utils_begin", "`uvm_object_abstract_utils_begin"));
        String libObjectUtilsEnd = isOVMLib ? "`ovm_object_utils_end" : "`uvm_object_utils_end";
        HashSet<String> libObjectParamUtilsBegin = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_object_param_utils_begin") : Arrays.asList("`uvm_object_param_utils_begin", "`uvm_object_abstract_param_utils_begin"));
        HashSet<String> libObjectParamUtils = new HashSet<String>(isOVMLib ? Arrays.asList("`ovm_object_param_utils") : Arrays.asList("`uvm_object_param_utils", "`uvm_object_abstract_param_utils"));
        String libSequenceUtils = "`ovm_sequence_utils";
        String libSequenceUtilsBegin = "`ovm_sequence_utils_begin";
        String libSequenceUtilsEnd = "`ovm_sequence_utils_end";
        this.checkMacroUtilsBeginEnd(this.fOVMProject.fMonitors, libComponentsUtils, libComponentsUtilsBegin, libComponentsUtilsEnd, libComponentsParamUtils, libComponentsParamUtilsBegin, true);
        if (isOVMLib) {
            this.checkMacroUtilsBeginEnd(this.fOVMProject.fSequencers, libSequencerUtils, libSequencerUtilsBegin, libSequencerUtilsEnd, libSequencerParamUtils, libSequencerParamUtilsBegin, true);
        } else {
            this.checkMacroUtilsBeginEnd(this.fOVMProject.fSequencers, libComponentsUtils, libComponentsUtilsBegin, libComponentsUtilsEnd, libComponentsParamUtils, libComponentsParamUtilsBegin, true);
        }
        this.checkMacroUtilsBeginEnd(this.fOVMProject.fAgents, libComponentsUtils, libComponentsUtilsBegin, libComponentsUtilsEnd, libComponentsParamUtils, libComponentsParamUtilsBegin, true);
        this.checkMacroUtilsBeginEnd(this.fOVMProject.fDrivers, libComponentsUtils, libComponentsUtilsBegin, libComponentsUtilsEnd, libComponentsParamUtils, libComponentsParamUtilsBegin, true);
        this.checkMacroUtilsBeginEnd(this.fOVMProject.fEnvs, libComponentsUtils, libComponentsUtilsBegin, libComponentsUtilsEnd, libComponentsParamUtils, libComponentsParamUtilsBegin, true);
        this.checkMacroUtilsBeginEnd(this.getClassesWithPatterns("testbenchClassNamePattern"), libComponentsUtils, libComponentsUtilsBegin, libComponentsUtilsEnd, libComponentsParamUtils, libComponentsParamUtilsBegin, true);
        this.checkMacroUtilsBeginEnd(this.fOVMProject.fTests, libComponentsUtils, libComponentsUtilsBegin, libComponentsUtilsEnd, libComponentsParamUtils, libComponentsParamUtilsBegin, true);
        this.checkMacroUtilsBeginEnd(this.fOVMProject.fSequenceItems, libObjectUtils, libObjectUtilsBegin, libObjectUtilsEnd, libObjectParamUtils, libObjectParamUtilsBegin, true);
        if (isOVMLib) {
            this.checkMacroUtilsBeginEnd(this.fOVMProject.fSequences, libSequenceUtils, libSequenceUtilsBegin, libSequenceUtilsEnd, null, null, true);
        } else {
            this.checkMacroUtilsBeginEnd(this.fOVMProject.fSequences, libObjectUtils, libObjectUtilsBegin, libObjectUtilsEnd, libObjectParamUtils, libObjectParamUtilsBegin, true);
        }
    }
}

