/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Arrays;
import java.util.HashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractUtilsMacroCheck;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="3.1")
@CheckID(value="XVM5")
@CheckName(value="XVM5")
@CheckLabel(labels={RuleLabel.FACTORY_REGISTRATION, RuleLabel.UVM_SEQUENCE, RuleLabel.REGISTRATION_MACRO, RuleLabel.VERIFICATION})
@CheckTitle(value="Sequence Factory Registration")
@CheckDescription(value="Verify that sequence declaration contains proper usage of the `uvm_object_utils macro: `uvm_object_utils(seq_type, sequencer_type) or `uvm_object_begin() ... `uvm_object_utils_end.\n\nException: Virtual sequences are not checked.")
public class CheckUVM5
extends AbstractUtilsMacroCheck {
    public CheckUVM5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        HashSet<String> relevantMacros = new HashSet<String>();
        relevantMacros.addAll(Arrays.asList(XVMMacros.OVM_CLASS_MACROS));
        relevantMacros.addAll(Arrays.asList(XVMMacros.UVM_CLASS_MACROS));
        aRfProject.lintTrackMacrosByNames("class", relevantMacros);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequences.isEmpty()) {
            return;
        }
        String libSequenceUtils = "`ovm_sequence_utils";
        String libSequenceUtilsBegin = "`ovm_sequence_utils_begin";
        String libSequenceUtilsEnd = "`ovm_sequence_utils_end";
        String libObjectUtilsEnd = "`uvm_object_utils_end";
        HashSet<String> libObjectUtils = new HashSet<String>(Arrays.asList("`uvm_object_utils", "`uvm_object_abstract_utils"));
        HashSet<String> libObjectUtilsBegin = new HashSet<String>(Arrays.asList("`uvm_object_utils_begin", "`uvm_object_abstract_utils_begin"));
        HashSet<String> libObjectParamUtilsBegin = new HashSet<String>(Arrays.asList("`uvm_object_param_utils_begin", "`uvm_object_abstract_param_utils_begin"));
        HashSet<String> libObjectParamUtils = new HashSet<String>(Arrays.asList("`uvm_object_param_utils", "`uvm_object_abstract_param_utils"));
        if (this.fOVMProject.getLibraryKind() == 1) {
            this.checkMacroUtilsBeginEnd(this.fOVMProject.fSequences, libSequenceUtils, libSequenceUtilsBegin, libSequenceUtilsEnd, null, null, true);
        } else {
            this.checkMacroUtilsBeginEnd(this.fOVMProject.fSequences, libObjectUtils, libObjectUtilsBegin, libObjectUtilsEnd, libObjectParamUtils, libObjectParamUtilsBegin, true);
        }
    }
}

