/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.DVTProblemMatcher;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.model.problems.VlogProblemKinds;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.standard.checks.AbstractCompilationErrorCheck;

@CheckVersion(value="3.1")
@CheckID(value="NON_STANDARD")
@CheckName(value="NON_STANDARD")
@CheckLabel(labels={RuleLabel.COMPILATION})
@CheckTitle(value="Non Standard Constructs")
@CheckDescription(value="This check shows the non-standard constructs reported during compilation.\nBy default all the non-standard failures will be shown.\nIf the <includeIDs> parameter is specified, only the failures matching the specified IDs will be shown.\nIf the <excludeIDs> parameter is specified, all the failures except for those matching the specified IDs will be shown.\nThe <includeIDs> parameter cannot be used together with the <excludeIDs> parameter.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="showFailureDetails", description="When true, show each non-standard construct, when false, only show that there are problems.", defaultValue="true"), @CheckParameterOverride(name="show", defaultValue="ERROR, WARNING, INFO")})
public class NonStandardCheck
extends AbstractCompilationErrorCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of included non standard check IDs. This parameter cannot be used together with the <excludeIDs> parameter. When empty, all IDs will be included.", name="includeIDs", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    public HashSet<String> pIncludeIDs;
    @CheckParameter(defaultValue="", description="Comma separated list of excluded non standard check IDs. This parameter cannot be used together with the <includeIDs> parameter. When empty, no IDs will be excluded.", name="excludeIDs", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    public HashSet<String> pExcludeIDs;

    public NonStandardCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public String getErrorMessage() {
        return "Found non-standard constructs!";
    }

    @Override
    public void configure() {
        super.configure();
        for (String showValue : this.pShowValueAsStrings) {
            Severity severity = Severity.from((String)showValue);
            if (severity == null) {
                this.signalParamError("Invalid value: " + showValue + " for 'show' parameter", true);
                continue;
            }
            this.pShowValue.add(severity);
        }
        if (!this.pIncludeIDs.isEmpty() && !this.pExcludeIDs.isEmpty()) {
            this.signalParamError("Parameter 'includeIDs' cannot be used together with 'excludeIDs'!", true);
        }
    }

    @Override
    public List<DVTProblem> getIssues() {
        String includeExcludeIDsReggex = "";
        StringBuilder sb = new StringBuilder();
        sb.append("^(");
        int i = 0;
        if (!this.pIncludeIDs.isEmpty()) {
            for (String id : this.pIncludeIDs) {
                if (i > 0) {
                    sb.append("|");
                }
                sb.append(id);
                ++i;
            }
        } else if (!this.pExcludeIDs.isEmpty()) {
            for (String id : this.pExcludeIDs) {
                if (i > 0) {
                    sb.append("|");
                }
                sb.append(id);
                ++i;
            }
        }
        sb.append("):.*$");
        includeExcludeIDsReggex = sb.toString();
        ArrayList<DVTProblem> result = new ArrayList<DVTProblem>();
        Collection allSyntaxErrors = DVTProblemManager.getInstance().getAllProblems(this.getIProject(), DVTProblemMatcher.all().setKind(VlogProblemKinds.SYNTAX_ERROR.getId()), null);
        Collection allSyntaxWarnings = DVTProblemManager.getInstance().getAllProblems(this.getIProject(), DVTProblemMatcher.all().setKind(VlogProblemKinds.SYNTAX_WARNING.getId()), null);
        Collection allSemanticErrors = DVTProblemManager.getInstance().getAllProblems(this.getIProject(), DVTProblemMatcher.all().setKind(VlogProblemKinds.SEMANTIC_ERROR.getId()), null);
        Collection allSemanticWarnings = DVTProblemManager.getInstance().getAllProblems(this.getIProject(), DVTProblemMatcher.all().setKind(VlogProblemKinds.SEMANTIC_WARNING.getId()), null);
        if (allSemanticErrors != null) {
            result.addAll(allSemanticErrors);
        }
        if (allSemanticWarnings != null) {
            result.addAll(allSemanticWarnings);
        }
        if (allSyntaxErrors != null) {
            result.addAll(allSyntaxErrors);
        }
        if (allSyntaxWarnings != null) {
            result.addAll(allSyntaxWarnings);
        }
        List<DVTProblem> filterAndSort = this.filterAndSort(result, true);
        result.clear();
        for (DVTProblem issue : filterAndSort) {
            String issueMessage = this.getIssueMessage(issue);
            if (!this.pIncludeIDs.isEmpty() ? !Pattern.matches(includeExcludeIDsReggex, issueMessage) : !this.pExcludeIDs.isEmpty() && Pattern.matches(includeExcludeIDsReggex, issueMessage)) continue;
            result.add(issue);
        }
        return result;
    }
}

